/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythicenchants.enchants;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.lumine.mythic.bukkit.utils.config.properties.Property;
import io.lumine.mythic.bukkit.utils.config.properties.PropertyHolder;
import io.lumine.mythic.bukkit.utils.config.properties.types.BooleanProp;
import io.lumine.mythic.bukkit.utils.config.properties.types.IntProp;
import io.lumine.mythic.bukkit.utils.config.properties.types.StringListProp;
import io.lumine.mythic.bukkit.utils.config.properties.types.StringProp;
import io.lumine.mythic.bukkit.utils.logging.Log;
import io.lumine.mythic.bukkit.utils.text.Text;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythicenchants.MythicEnchants;
import io.lumine.mythicenchants.config.Scope;
import io.lumine.mythicenchants.enchants.EnchantManager;
import io.lumine.mythicenchants.enchants.properties.EnchantSlot;
import io.lumine.mythicenchants.enchants.properties.rarity.EnchantRarity;
import io.lumine.mythicenchants.util.LoreParser;
import io.papermc.paper.enchantments.EnchantmentRarity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.enchantments.EnchantmentTarget;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public abstract class MythicEnchant
implements PropertyHolder {
    private static final StringProp DISPLAY = Property.String((Object)((Object)Scope.NONE), (String)"Display", (String)"Please Configure an Enchant Name");
    private static final StringProp RARITY = Property.String((Object)((Object)Scope.NONE), (String)"Rarity");
    private static final IntProp MIN_LEVEL = Property.Int((Object)((Object)Scope.NONE), (String)"MinLevel", (int)1);
    private static final IntProp MAX_LEVEL = Property.Int((Object)((Object)Scope.NONE), (String)"MaxLevel", (int)5);
    private static final IntProp MERGE_COST = Property.Int((Object)((Object)Scope.NONE), (String)"MergeCostPerLevel", (int)1);
    private static final StringListProp VALID_SLOTS = Property.StringList((Object)((Object)Scope.NONE), (String)"ValidSlots");
    private static final BooleanProp CURSED = Property.Boolean((Object)((Object)Scope.NONE), (String)"Cursed", (boolean)false);
    private static final BooleanProp TREASURE = Property.Boolean((Object)((Object)Scope.NONE), (String)"Treasure", (boolean)false);
    private static final IntProp TABLE_MIN_XP = Property.Int((Object)((Object)Scope.NONE), (String)"EnchantingTable.MinExperience", (int)0);
    private static final IntProp TABLE_MAX_XP = Property.Int((Object)((Object)Scope.NONE), (String)"EnchantingTable.MaxExperience", (int)30);
    private static final IntProp TABLE_MIN_LEVEL = Property.Int((Object)((Object)Scope.NONE), (String)"EnchantingTable.MinLevel", (int)-1);
    private static final IntProp TABLE_MAX_LEVEL = Property.Int((Object)((Object)Scope.NONE), (String)"EnchantingTable.MaxLevel", (int)-1);
    private static final StringListProp CONFLICTING = Property.StringList((Object)((Object)Scope.NONE), (String)"ConflictingEnchants");
    private static final StringListProp VALID_TYPES = Property.StringList((Object)((Object)Scope.NONE), (String)"EnchantableItems");
    private final EnchantManager enchantManager;
    private final Object scope;
    private final String name;
    private final NamespacedKey key;
    protected String displayName;
    protected EnchantRarity rarityCategory;
    protected int startLevel;
    protected int maxLevel;
    protected EnchantmentTarget itemTarget;
    protected boolean cursed;
    protected boolean treasure;
    protected Boolean stacksLevels = false;
    protected int minTableExperience;
    protected int maxTableExperience;
    protected int minTableLevel;
    protected int maxTableLevel;
    protected int maxModifiedCost = 0;
    protected int mergeCostPerLevel;
    private Set<EquipmentSlot> activeSlots = Sets.newHashSet();
    protected Collection<EnchantSlot> applicableSlots = Lists.newArrayList();
    protected List<Material> enchantableMaterials = Lists.newArrayList();
    protected List<String> conflictingEnchants = Lists.newArrayList();
    protected transient Enchantment bukkitEnchantment;

    public MythicEnchant(EnchantManager manager, Object scope, String name) {
        this.enchantManager = manager;
        this.scope = scope;
        this.name = name;
        this.key = new NamespacedKey((Plugin)manager.getPlugin(), name.toLowerCase());
    }

    public void load() {
        this.displayName = (String)DISPLAY.fget(this.scope, (PropertyHolder)this);
        if (this.enchantManager.getRarities() != null) {
            MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)"{0} rarities loaded. ", (Object[])new Object[]{this.enchantManager.getRarities().size()});
        }
        this.rarityCategory = this.enchantManager.getRarities().getOrDefault(RARITY.fget(this.scope, (PropertyHolder)this), null);
        this.startLevel = (Integer)MIN_LEVEL.fget(this.scope, (PropertyHolder)this);
        this.maxLevel = (Integer)MAX_LEVEL.fget(this.scope, (PropertyHolder)this);
        this.cursed = (Boolean)CURSED.fget(this.scope, (PropertyHolder)this);
        this.treasure = (Boolean)TREASURE.fget(this.scope, (PropertyHolder)this);
        this.mergeCostPerLevel = (Integer)MERGE_COST.fget(this.scope, (PropertyHolder)this);
        this.loadEnchantTableValues();
        if (this.minTableLevel < 0) {
            this.minTableLevel = this.startLevel;
        }
        if (this.maxTableLevel < 0) {
            this.maxTableLevel = this.maxLevel;
        }
        this.applicableSlots.clear();
        for (String string : (List)VALID_SLOTS.fget(this.scope, (PropertyHolder)this)) {
            try {
                EnchantSlot slot = EnchantSlot.valueOf(string);
                this.applicableSlots.add(slot);
                this.activeSlots.add(slot.toEquipmentSlot());
            }
            catch (IllegalArgumentException e) {
                MythicEnchants.inst().getLogger().log(Level.SEVERE, "Invalid slot specified for " + this.getName() + " enchantment.", e);
            }
        }
        this.enchantableMaterials.clear();
        for (String string : (List)VALID_TYPES.fget(this.scope, (PropertyHolder)this)) {
            try {
                Material mat = Material.valueOf((String)string.toUpperCase());
                this.enchantableMaterials.add(mat);
            }
            catch (Exception exception) {}
        }
        this.conflictingEnchants.clear();
        for (String string : (List)CONFLICTING.fget(this.scope, (PropertyHolder)this)) {
            this.conflictingEnchants.add(string.toUpperCase());
        }
        if (this.rarityCategory != null) {
            Log.info((String)"Loaded Custom Enchantment {0} with rarity {1}", (Object[])new Object[]{this.name, this.rarityCategory.getDisplay()});
            return;
        }
        Log.info((String)"Loaded Custom Enchantment {0} with no set rarity", (Object[])new Object[]{this.name});
    }

    protected void loadEnchantTableValues() {
        this.minTableExperience = (Integer)TABLE_MIN_XP.fget(this.scope, (PropertyHolder)this);
        this.maxTableExperience = (Integer)TABLE_MAX_XP.fget(this.scope, (PropertyHolder)this);
        this.minTableLevel = (Integer)TABLE_MIN_LEVEL.fget(this.scope, (PropertyHolder)this);
        this.maxTableLevel = (Integer)TABLE_MAX_LEVEL.fget(this.scope, (PropertyHolder)this);
    }

    public String getPropertyNode() {
        return this.name;
    }

    @NotNull
    public Key key() {
        return Key.key((String)"mythicenchants", (String)this.getPropertyNode().toLowerCase());
    }

    public boolean canEnchantItem(ItemStack item) {
        return this.enchantableMaterials.isEmpty() || this.enchantableMaterials.contains(item.getType());
    }

    public boolean conflictsWith(Enchantment enchant) {
        return !this.enchantableMaterials.isEmpty() && this.conflictingEnchants.contains(enchant.getKey().getKey().toUpperCase());
    }

    public boolean conflictsWith(Collection<Enchantment> enchantments) {
        for (Enchantment ench : enchantments) {
            if (!this.conflictsWith(ench)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Component displayName(int i) {
        return MiniMessage.miniMessage().deserialize((Object)LoreParser.formatEnchantment(this, i));
    }

    public boolean isTradeable() {
        return false;
    }

    public boolean isDiscoverable() {
        return false;
    }

    @NotNull
    public EnchantmentRarity getRarity() {
        return EnchantmentRarity.VERY_RARE;
    }

    public String getDisplayTagless() {
        return Text.replaceLegacy((String)this.displayName).replaceAll("<.*?>", "");
    }

    public ItemStack removeLore(ItemStack item, int level) {
        ItemMeta meta = item.getItemMeta();
        List lore = meta.hasLore() ? meta.getLore() : new ArrayList();
        String match = ChatColor.stripColor((String)LoreParser.formatEnchantment(this, level));
        lore.removeIf(line -> {
            MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.SKILL, (String)"Raw Line: {0}", (Object[])new Object[]{line});
            MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.SKILL, (String)"Match: {0}", (Object[])new Object[]{match});
            String check = Text.replaceLegacy((String)line).replaceAll("<.*?>", "").replace("&x", "");
            MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.SKILL, (String)"Checking {0} against {1}", (Object[])new Object[]{check, this.getDisplayTagless()});
            if (check.startsWith(this.getDisplayTagless())) {
                MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.SKILL, (String)"Removing {0}", (Object[])new Object[]{line});
                return true;
            }
            return false;
        });
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    public boolean isEnabled() {
        return true;
    }

    public double getTableChance(int lapis) {
        return this.rarityCategory.getChanceEnchantingTable().getOrDefault(lapis, 0.0);
    }

    public int getTableMinimumCost(int lapis) {
        return this.rarityCategory.getMinCostEnchantingTable().getOrDefault(lapis, 1);
    }

    public int getTableMinimumLevel(int lapis) {
        return this.rarityCategory.getMinLevelEnchantingTable().getOrDefault(lapis, 1);
    }

    public boolean equals(Object o) {
        if (o instanceof MythicEnchant) {
            MythicEnchant mythicEnchant = (MythicEnchant)o;
            return mythicEnchant.getPropertyNode().equals(this.getPropertyNode());
        }
        return false;
    }

    public EnchantManager getEnchantManager() {
        return this.enchantManager;
    }

    public Object getScope() {
        return this.scope;
    }

    public String getName() {
        return this.name;
    }

    public NamespacedKey getKey() {
        return this.key;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public EnchantRarity getRarityCategory() {
        return this.rarityCategory;
    }

    public int getStartLevel() {
        return this.startLevel;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public EnchantmentTarget getItemTarget() {
        return this.itemTarget;
    }

    public boolean isCursed() {
        return this.cursed;
    }

    public boolean isTreasure() {
        return this.treasure;
    }

    public Boolean getStacksLevels() {
        return this.stacksLevels;
    }

    public int getMinTableExperience() {
        return this.minTableExperience;
    }

    public int getMaxTableExperience() {
        return this.maxTableExperience;
    }

    public int getMinTableLevel() {
        return this.minTableLevel;
    }

    public int getMaxTableLevel() {
        return this.maxTableLevel;
    }

    public int getMaxModifiedCost() {
        return this.maxModifiedCost;
    }

    public int getMergeCostPerLevel() {
        return this.mergeCostPerLevel;
    }

    public Set<EquipmentSlot> getActiveSlots() {
        return this.activeSlots;
    }

    public Collection<EnchantSlot> getApplicableSlots() {
        return this.applicableSlots;
    }

    public List<Material> getEnchantableMaterials() {
        return this.enchantableMaterials;
    }

    public List<String> getConflictingEnchants() {
        return this.conflictingEnchants;
    }

    public Enchantment getBukkitEnchantment() {
        return this.bukkitEnchantment;
    }

    public void setBukkitEnchantment(Enchantment bukkitEnchantment) {
        this.bukkitEnchantment = bukkitEnchantment;
    }
}

