/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythicenchants.enchants;

import com.google.common.collect.Maps;
import io.lumine.mythic.api.skills.ISkillMechanic;
import io.lumine.mythic.api.skills.conditions.ISkillCondition;
import io.lumine.mythic.bukkit.events.MythicApplyEnchantEvent;
import io.lumine.mythic.bukkit.events.MythicConditionLoadEvent;
import io.lumine.mythic.bukkit.events.MythicMechanicLoadEvent;
import io.lumine.mythic.bukkit.events.MythicReloadedEvent;
import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.bukkit.utils.config.properties.Property;
import io.lumine.mythic.bukkit.utils.config.properties.types.NodeListProp;
import io.lumine.mythic.bukkit.utils.items.ItemFactory;
import io.lumine.mythic.bukkit.utils.logging.Log;
import io.lumine.mythic.bukkit.utils.plugin.LuminePlugin;
import io.lumine.mythic.bukkit.utils.plugin.ReloadableModule;
import io.lumine.mythic.bukkit.utils.terminable.TerminableConsumer;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythicenchants.MythicEnchants;
import io.lumine.mythicenchants.config.Scope;
import io.lumine.mythicenchants.enchants.EnchantmentFactory;
import io.lumine.mythicenchants.enchants.MythicEnchant;
import io.lumine.mythicenchants.enchants.custom.conditions.EnchantLevelCondition;
import io.lumine.mythicenchants.enchants.custom.conditions.EnchantSlotCondition;
import io.lumine.mythicenchants.enchants.custom.mechanics.EnchantItemMechanic;
import io.lumine.mythicenchants.enchants.properties.rarity.EnchantRarity;
import io.lumine.mythicenchants.enchants.stations.AnvilHandler;
import io.lumine.mythicenchants.enchants.stations.EnchantmentTableHandler;
import io.lumine.mythicenchants.enchants.stations.GrindstoneHandler;
import io.lumine.mythicenchants.profiles.EnchantsProfile;
import io.lumine.mythicenchants.util.LoreParser;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class EnchantManager
extends ReloadableModule<MythicEnchants> {
    private static final NodeListProp RARITIES = Property.NodeList((Object)((Object)Scope.RARITIES), (String)"");
    protected Map<String, EnchantRarity> rarities = Maps.newConcurrentMap();
    protected Map<String, List<MythicEnchant>> enchantableTypes = Maps.newConcurrentMap();
    protected Map<String, MythicEnchant> enchantments = Maps.newConcurrentMap();
    protected Map<String, MythicEnchant> enchantmentsDisplay = Maps.newConcurrentMap();
    protected Map<Enchantment, MythicEnchant> bukkitEnchantmentLookup = Maps.newConcurrentMap();
    private EnchantmentFactory enchantmentFactory;
    private AnvilHandler anvilHandler;
    private GrindstoneHandler grindstoneHandler;
    private EnchantmentTableHandler enchantmentTableHandler;

    public EnchantManager(MythicEnchants plugin) {
        super((LuminePlugin)plugin, false);
    }

    public void load(MythicEnchants plugin) {
        Log.info((String)"Loading rarities");
        this.loadRarities();
        if (this.enchantmentFactory == null) {
            this.enchantmentFactory = new EnchantmentFactory(plugin, this);
        }
        this.enchantmentFactory.reload();
        Log.info((String)"Initialising Enchant Stations!");
        this.anvilHandler = new AnvilHandler(plugin, this);
        this.grindstoneHandler = new GrindstoneHandler(plugin, this);
        Log.info((String)"Initialising Enchantment Table!");
        this.enchantmentTableHandler = new EnchantmentTableHandler(plugin, this);
        Log.info((String)"Loading Enchant Manager");
        this.subscribeEnchantEvents();
    }

    public void unload() {
        this.rarities.clear();
        this.enchantments.clear();
        this.enchantmentsDisplay.clear();
    }

    public Collection<String> getEnchantmentNames() {
        return this.enchantments.keySet();
    }

    public Optional<MythicEnchant> toMythicEnchantment(Enchantment enchantment) {
        return Optional.ofNullable(this.bukkitEnchantmentLookup.get(enchantment));
    }

    public boolean isRegistered(String enchantmentName) {
        return this.enchantments.containsKey(enchantmentName);
    }

    public Map<MythicEnchant, Integer> getMythicEnchants(ItemStack item) {
        HashMap<MythicEnchant, Integer> map = new HashMap<MythicEnchant, Integer>();
        if (item == null || item.getType() == Material.AIR || !item.hasItemMeta()) {
            return map;
        }
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta instanceof EnchantmentStorageMeta) {
            EnchantmentStorageMeta meta = (EnchantmentStorageMeta)itemMeta;
            meta.getStoredEnchants().forEach((enchant, level) -> this.toMythicEnchantment((Enchantment)enchant).ifPresent(mythicEnchant -> map.put((MythicEnchant)mythicEnchant, (Integer)level)));
        } else {
            item.getItemMeta().getEnchants().forEach((enchant, level) -> this.toMythicEnchantment((Enchantment)enchant).ifPresent(mythicEnchant -> map.put((MythicEnchant)mythicEnchant, (Integer)level)));
        }
        return map;
    }

    public boolean applyEnchantment(ItemStack item, String strEnchant, int level) {
        if (this.isRegistered(strEnchant)) {
            this.applyToItem(item, this.enchantments.get(strEnchant), level);
            return true;
        }
        Enchantment ench = Enchantment.getByName((String)strEnchant.toUpperCase());
        if (ench != null) {
            item.addUnsafeEnchantment(ench, level);
            return true;
        }
        return false;
    }

    public ItemStack applyToItem(ItemStack item, MythicEnchant enchant, int level) {
        int lvl;
        ItemFactory factory = ItemFactory.of((ItemStack)item);
        if (item.getType() == Material.BOOK) {
            factory.type(Material.ENCHANTED_BOOK);
        }
        if ((lvl = this.getMythicEnchants(item).getOrDefault(enchant, 0).intValue()) > 0) {
            enchant.removeLore(item, lvl);
        }
        if (!item.getItemMeta().hasItemFlag(ItemFlag.HIDE_ENCHANTS)) {
            factory.prependLore(LoreParser.formatEnchantment(enchant, level));
            MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)("Enchanting item with " + enchant.getName() + " at level " + level + " with lore " + LoreParser.formatEnchantment(enchant, level)), (Object[])new Object[0]);
        }
        factory.enchant(enchant.getBukkitEnchantment(), level);
        return factory.build();
    }

    public boolean removeEnchantment(ItemStack item, String strEnchant) {
        MythicEnchant enchantmentToRemove = this.enchantments.get(strEnchant);
        if (enchantmentToRemove == null) {
            return false;
        }
        return this.removeEnchantment(item, enchantmentToRemove.getBukkitEnchantment());
    }

    private boolean removeEnchantment(ItemStack item, Enchantment enchant) {
        Optional<MythicEnchant> maybeMythicEnchant = this.toMythicEnchantment(enchant);
        if (maybeMythicEnchant.isPresent()) {
            return this.removeMythicEnchantment(item, maybeMythicEnchant.get());
        }
        return this.removeNonMythicEnchantment(item, enchant);
    }

    public void removeEnchantment(ItemStack item, MythicEnchant mythicEnchant, int level) {
        MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)("Removing " + mythicEnchant.getName() + " at level " + level), (Object[])new Object[0]);
        if (level == 0) {
            MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)"Level is 0", (Object[])new Object[0]);
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta instanceof EnchantmentStorageMeta) {
            EnchantmentStorageMeta storageMeta = (EnchantmentStorageMeta)meta;
            storageMeta.removeStoredEnchant(mythicEnchant.getBukkitEnchantment());
        } else {
            meta.removeEnchant(mythicEnchant.getBukkitEnchantment());
        }
        item.setItemMeta(meta);
        mythicEnchant.removeLore(item, level);
    }

    public void register(MythicEnchant enchantToRegister) {
        ((MythicEnchants)this.getPlugin()).getVolatileCodeHandler().registerEnchantment(enchantToRegister);
        NamespacedKey key = enchantToRegister.getKey();
        Enchantment bukkitEnchantment = Enchantment.getByKey((NamespacedKey)key);
        if (bukkitEnchantment == null && (bukkitEnchantment = Enchantment.getByName((String)enchantToRegister.getName())) == null) {
            try {
                throw new IllegalStateException("danger danger enchant failed to register");
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
        }
        this.bukkitEnchantmentLookup.put(bukkitEnchantment, enchantToRegister);
        enchantToRegister.setBukkitEnchantment(bukkitEnchantment);
    }

    private boolean removeMythicEnchantment(ItemStack item, MythicEnchant mythicEnchant) {
        int level;
        ItemMeta meta = item.getItemMeta();
        if (meta instanceof EnchantmentStorageMeta) {
            EnchantmentStorageMeta storageMeta = (EnchantmentStorageMeta)meta;
            level = storageMeta.getStoredEnchantLevel(mythicEnchant.getBukkitEnchantment());
            storageMeta.removeStoredEnchant(mythicEnchant.getBukkitEnchantment());
        } else {
            level = meta.getEnchantLevel(mythicEnchant.getBukkitEnchantment());
            meta.removeEnchant(mythicEnchant.getBukkitEnchantment());
        }
        item.setItemMeta(meta);
        if (level > 0) {
            mythicEnchant.removeLore(item, level);
        }
        return true;
    }

    private boolean removeNonMythicEnchantment(ItemStack item, Enchantment enchant) {
        if (enchant != null) {
            ItemMeta meta = item.getItemMeta();
            if (meta instanceof EnchantmentStorageMeta) {
                EnchantmentStorageMeta storageMeta = (EnchantmentStorageMeta)meta;
                storageMeta.removeStoredEnchant(enchant);
            } else {
                meta.removeEnchant(enchant);
            }
            item.setItemMeta(meta);
            return true;
        }
        return false;
    }

    private void loadRarities() {
        for (String node : (Set)RARITIES.get()) {
            EnchantRarity rarity = new EnchantRarity(node);
            MythicLogger.log((String)"Loaded {0} rarity", (Object[])new Object[]{rarity.getDisplay()});
            this.rarities.put(rarity.getPropertyNode(), rarity);
        }
    }

    private void subscribeEnchantEvents() {
        Events.subscribe(MythicApplyEnchantEvent.class).handler(event -> this.toMythicEnchantment(event.getEnchantment()).ifPresent(mythicEnchant -> this.applyToItem(event.getItem(), (MythicEnchant)mythicEnchant, event.getLevel()))).bindWith((TerminableConsumer)this);
        Events.subscribe(MythicReloadedEvent.class).handler(event -> {
            this.enchantmentFactory.reload();
            ((MythicEnchants)this.getPlugin()).getProfileManager().getKnownProfiles().forEach(EnchantsProfile::parseEquipment);
        }).bindWith((TerminableConsumer)this);
        Events.subscribe(MythicMechanicLoadEvent.class).handler(event -> {
            switch (event.getMechanicName().toUpperCase()) {
                case "ENCHANTITEM": {
                    event.register((ISkillMechanic)new EnchantItemMechanic(event.getConfig()));
                    return;
                }
            }
        }).bindWith((TerminableConsumer)this);
        Events.subscribe(MythicConditionLoadEvent.class).handler(event -> {
            switch (event.getConditionName().toUpperCase()) {
                case "ENCHANTLEVEL": {
                    event.register((ISkillCondition)new EnchantLevelCondition(event.getConfig(), event.getArgument()));
                    break;
                }
                case "ENCHANTSLOT": 
                case "ENCHANTMENTSLOT": {
                    event.register((ISkillCondition)new EnchantSlotCondition(event.getConfig(), event.getArgument()));
                }
            }
        }).bindWith((TerminableConsumer)this);
    }

    public Map<String, EnchantRarity> getRarities() {
        return this.rarities;
    }

    public Map<String, List<MythicEnchant>> getEnchantableTypes() {
        return this.enchantableTypes;
    }

    public Map<String, MythicEnchant> getEnchantments() {
        return this.enchantments;
    }

    public Map<String, MythicEnchant> getEnchantmentsDisplay() {
        return this.enchantmentsDisplay;
    }

    public Map<Enchantment, MythicEnchant> getBukkitEnchantmentLookup() {
        return this.bukkitEnchantmentLookup;
    }

    public EnchantmentFactory getEnchantmentFactory() {
        return this.enchantmentFactory;
    }

    public AnvilHandler getAnvilHandler() {
        return this.anvilHandler;
    }

    public GrindstoneHandler getGrindstoneHandler() {
        return this.grindstoneHandler;
    }

    public EnchantmentTableHandler getEnchantmentTableHandler() {
        return this.enchantmentTableHandler;
    }
}

