/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythicenchants.commands.sub;

import io.lumine.mythic.bukkit.utils.commands.Command;
import io.lumine.mythicenchants.MythicEnchants;
import io.lumine.mythicenchants.commands.CommandHelper;
import io.lumine.mythicenchants.constants.CommandPermissions;
import io.lumine.mythicenchants.profiles.EnchantsProfile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.StringUtil;

public class EnchantRemoveCommand
extends Command<MythicEnchants> {
    public EnchantRemoveCommand(Command<MythicEnchants> parent) {
        super(parent);
    }

    public boolean onCommand(CommandSender sender, String[] args) {
        if (args.length < 1) {
            CommandHelper.sendError(sender, "Command Syntax: /me remove <enchantment>");
            return true;
        }
        Player target = (Player)sender;
        String strEnchant = args[0];
        if (target == null) {
            CommandHelper.sendError(sender, "That player is not online");
            return true;
        }
        ItemStack item = target.getInventory().getItemInMainHand();
        if (!((MythicEnchants)this.getPlugin()).getEnchantManager().isRegistered(strEnchant)) {
            CommandHelper.sendError(sender, "Enchantment doesnt exist");
            return true;
        }
        if (!((MythicEnchants)this.getPlugin()).getEnchantManager().removeEnchantment(item, strEnchant)) {
            CommandHelper.sendError(sender, "Failed to remove enchantment");
        }
        ((EnchantsProfile)((MythicEnchants)this.getPlugin()).getProfileManager().getProfile(target)).parseWeapons();
        CommandHelper.sendSuccess(sender, "Enchantment removed from item.");
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, String[] args) {
        if (args.length == 1) {
            return (List)StringUtil.copyPartialMatches((String)args[0], MythicEnchants.inst().getEnchantManager().getEnchantmentNames(), new ArrayList());
        }
        return Collections.emptyList();
    }

    public String getPermissionNode() {
        return CommandPermissions.PERMISSION_COMMAND_ENCHANT.getPermissionString();
    }

    public boolean isConsoleFriendly() {
        return false;
    }

    public String getName() {
        return "remove";
    }
}

