/*
 * Decompiled with CFR 0.152.
 */
package me.ceze88;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.maven.plugins.shade.relocation.Relocator;
import org.apache.maven.plugins.shade.resource.ResourceTransformer;
import org.yaml.snakeyaml.Yaml;

public final class MavenYamlTransformer
implements ResourceTransformer {
    private static final Map<String, Object> resources = new HashMap<String, Object>();
    private static final Map<String, Object> mergedYaml = new HashMap<String, Object>();
    private List<String> paths = new ArrayList<String>();

    public List<String> getPaths() {
        return this.paths;
    }

    public void setPaths(List<String> paths) {
        this.paths = paths;
    }

    public boolean canTransformResource(String resource) {
        return this.matchesAnyPath(resource, this.paths);
    }

    public void processResource(String resource, InputStream inputStream, List<Relocator> relocators) throws IOException {
        if (resources.containsKey(resource)) {
            Yaml yaml = new Yaml();
            byte[] data = (byte[])resources.get(resource);
            Map existingYaml = (Map)yaml.load(new String(data));
            Map newYaml = (Map)yaml.load(inputStream);
            this.mergeMaps(existingYaml, newYaml);
            mergedYaml.put(resource, existingYaml);
        } else {
            byte[] data = inputStream.readAllBytes();
            resources.put(resource, data);
        }
    }

    private boolean matchesAnyPath(String resource, List<String> paths) {
        for (String path : paths) {
            if (!resource.endsWith(path)) continue;
            return true;
        }
        return false;
    }

    private void mergeMaps(Map<String, Object> target, Map<String, Object> source) {
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            target.merge(entry.getKey(), entry.getValue(), (v1, v2) -> {
                if (v1 instanceof Map && v2 instanceof Map) {
                    this.mergeMaps((Map)v1, (Map)v2);
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    return v1;
                }
                return v2;
            });
        }
    }

    public boolean hasTransformedResource() {
        return !mergedYaml.isEmpty();
    }

    public void modifyOutputStream(JarOutputStream jarOutputStream) throws IOException {
        for (Map.Entry<String, Object> entry : mergedYaml.entrySet()) {
            jarOutputStream.putNextEntry(new JarEntry(entry.getKey()));
            Yaml yaml = new Yaml();
            yaml.dump(entry.getValue(), new OutputStreamWriter(jarOutputStream));
            jarOutputStream.closeEntry();
        }
    }
}

