/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.google.common.io.Files;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.util.CommandPermissions;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.command.util.HookMode;
import com.sk89q.worldedit.command.util.PrintCommandHelp;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.event.platform.ConfigurationLoadEvent;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extension.platform.Capability;
import com.sk89q.worldedit.extension.platform.Platform;
import com.sk89q.worldedit.extension.platform.PlatformManager;
import com.sk89q.worldedit.util.formatting.component.MessageBox;
import com.sk89q.worldedit.util.formatting.component.TextComponentProducer;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.util.formatting.text.format.TextColor;
import com.sk89q.worldedit.util.paste.ActorCallbackPaste;
import com.sk89q.worldedit.util.report.ConfigReport;
import com.sk89q.worldedit.util.report.ReportList;
import com.sk89q.worldedit.util.report.SystemInfoReport;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.TextStyle;
import java.time.zone.ZoneRulesException;
import java.util.List;
import org.enginehub.piston.annotation.Command;
import org.enginehub.piston.annotation.CommandContainer;
import org.enginehub.piston.annotation.param.Arg;
import org.enginehub.piston.annotation.param.ArgFlag;
import org.enginehub.piston.annotation.param.Switch;

@CommandContainer(superTypes={CommandPermissionsConditionGenerator.Registration.class})
public class WorldEditCommands {
    private static final DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss z");
    private final WorldEdit we;

    public WorldEditCommands(WorldEdit we) {
        this.we = we;
    }

    @Command(name="version", aliases={"ver"}, desc="Get WorldEdit version")
    public void version(Actor actor) {
        actor.printInfo((Component)TranslatableComponent.of((String)"worldedit.version.version", (Component[])new Component[]{TextComponent.of((String)WorldEdit.getVersion())}));
        actor.printInfo((Component)TextComponent.of((String)"https://github.com/EngineHub/WorldEdit/"));
        PlatformManager pm = this.we.getPlatformManager();
        TextComponentProducer producer = new TextComponentProducer();
        for (Platform platform : pm.getPlatforms()) {
            producer.append(((TextComponent)TextComponent.of((String)"* ", (TextColor)TextColor.GRAY).append((Component)TextComponent.of((String)platform.getPlatformName()))).append((Component)TextComponent.of((String)("(" + platform.getPlatformVersion() + ")")))).newline();
        }
        actor.print((Component)new MessageBox("Platforms", producer, TextColor.GRAY).create());
        producer.reset();
        for (Capability capability : Capability.values()) {
            Platform platform = pm.queryCapability(capability);
            producer.append(TextComponent.of((String)capability.name(), (TextColor)TextColor.GRAY).append(TextComponent.of((String)": ").append((Component)TextComponent.of((String)(platform != null ? platform.getPlatformName() : "NONE"))))).newline();
        }
        actor.print((Component)new MessageBox("Capabilities", producer, TextColor.GRAY).create());
    }

    @Command(name="reload", desc="Reload configuration")
    @CommandPermissions(value={"worldedit.reload"})
    public void reload(Actor actor) {
        this.we.getPlatformManager().queryCapability(Capability.CONFIGURATION).reload();
        this.we.getEventBus().post(new ConfigurationLoadEvent(this.we.getPlatformManager().queryCapability(Capability.CONFIGURATION).getConfiguration()));
        actor.printInfo((Component)TranslatableComponent.of((String)"worldedit.reload.config"));
    }

    @Command(name="report", desc="Writes a report on WorldEdit")
    @CommandPermissions(value={"worldedit.report"})
    public void report(Actor actor, @Switch(name=112, desc="Pastebins the report") boolean pastebin) throws WorldEditException {
        ReportList report = new ReportList("Report");
        report.add(new SystemInfoReport());
        report.add(new ConfigReport());
        String result = report.toString();
        try {
            File dest = new File(this.we.getConfiguration().getWorkingDirectory(), "report.txt");
            Files.write((CharSequence)result, (File)dest, (Charset)StandardCharsets.UTF_8);
            actor.printInfo((Component)TranslatableComponent.of((String)"worldedit.report.written", (Component[])new Component[]{TextComponent.of((String)dest.getAbsolutePath())}));
        }
        catch (IOException e) {
            actor.printError((Component)TranslatableComponent.of((String)"worldedit.report.error", (Component[])new Component[]{TextComponent.of((String)e.getMessage())}));
        }
        if (pastebin) {
            actor.checkPermission("worldedit.report.pastebin");
            ActorCallbackPaste.pastebin(this.we.getSupervisor(), actor, result, TranslatableComponent.builder((String)"worldedit.report.callback"));
        }
    }

    @Command(name="trace", desc="Toggles trace hook")
    void trace(Actor actor, LocalSession session, @Arg(desc="The mode to set the trace hook to", def={""}) HookMode hookMode) {
        boolean newMode;
        boolean previousMode = session.isTracingActions();
        if (hookMode != null) {
            boolean bl = newMode = hookMode == HookMode.ACTIVE;
            if (newMode == previousMode) {
                actor.printError((Component)TranslatableComponent.of((String)(previousMode ? "worldedit.trace.active.already" : "worldedit.trace.inactive.already")));
                return;
            }
        } else {
            newMode = !previousMode;
        }
        session.setTracingActions(newMode);
        actor.printInfo((Component)TranslatableComponent.of((String)(newMode ? "worldedit.trace.active" : "worldedit.trace.inactive")));
    }

    @Command(name="cui", desc="Complete CUI handshake (internal usage)")
    public void cui(Player player, LocalSession session) {
        session.setCUISupport(true);
        session.dispatchCUISetup(player);
    }

    @Command(name="tz", desc="Set your timezone for snapshots")
    public void tz(Actor actor, LocalSession session, @Arg(desc="The timezone to set") String timezone) {
        try {
            ZoneId tz = ZoneId.of(timezone);
            session.setTimezone(tz);
            actor.printInfo((Component)TranslatableComponent.of((String)"worldedit.timezone.set", (Component[])new Component[]{TextComponent.of((String)tz.getDisplayName(TextStyle.FULL, actor.getLocale()))}));
            actor.printInfo((Component)TranslatableComponent.of((String)"worldedit.timezone.current", (Component[])new Component[]{TextComponent.of((String)dateFormat.withLocale(actor.getLocale()).format(ZonedDateTime.now(tz)))}));
        }
        catch (ZoneRulesException e) {
            actor.printError((Component)TranslatableComponent.of((String)"worldedit.timezone.invalid"));
        }
    }

    @Command(name="help", desc="Displays help for WorldEdit commands")
    @CommandPermissions(value={"worldedit.help"})
    public void help(Actor actor, @Switch(name=115, desc="List sub-commands of the given command, if applicable") boolean listSubCommands, @ArgFlag(name=112, desc="The page to retrieve", def={"1"}) int page, @Arg(desc="The command to retrieve help for", def={""}, variable=true) List<String> command) throws WorldEditException {
        PrintCommandHelp.help(command, page, listSubCommands, this.we.getPlatformManager().getPlatformCommandManager().getCommandManager(), actor, "/worldedit help");
    }
}

