/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.vollotile.specific;

import com.google.gson.JsonObject;
import de.tobiyas.util.RaC.chat.components.TellRawChatMessage;
import de.tobiyas.util.RaC.vollotile.ParticleEffects;
import de.tobiyas.util.RaC.vollotile.ReflectionsHelper;
import de.tobiyas.util.RaC.vollotile.VollotileCode;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.server.v1_9_R1.BlockPosition;
import net.minecraft.server.v1_9_R1.Entity;
import net.minecraft.server.v1_9_R1.EntityArrow;
import net.minecraft.server.v1_9_R1.EntityInsentient;
import net.minecraft.server.v1_9_R1.EntityPlayer;
import net.minecraft.server.v1_9_R1.IChatBaseComponent;
import net.minecraft.server.v1_9_R1.Item;
import net.minecraft.server.v1_9_R1.MinecraftKey;
import net.minecraft.server.v1_9_R1.Packet;
import net.minecraft.server.v1_9_R1.PacketDataSerializer;
import net.minecraft.server.v1_9_R1.PacketPlayOutChat;
import net.minecraft.server.v1_9_R1.PacketPlayOutCustomPayload;
import net.minecraft.server.v1_9_R1.PacketPlayOutPlayerListHeaderFooter;
import net.minecraft.server.v1_9_R1.PacketPlayOutTitle;
import net.minecraft.server.v1_9_R1.PathEntity;
import net.minecraft.server.v1_9_R1.PlayerConnection;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.craftbukkit.v1_9_R1.entity.CraftArrow;
import org.bukkit.craftbukkit.v1_9_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_9_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_9_R1.entity.CraftPlayer;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.util.Vector;

public class MC_1_9_R1_VollotileCode
extends VollotileCode {
    private static Field headerPacketField;
    private static Field footerPacketField;
    private Field localeField;

    public MC_1_9_R1_VollotileCode() {
        super("v1_9_R1");
    }

    @Override
    public void playCriticalHitEffect(Player toSendTo, org.bukkit.entity.Entity toPlayEffect) {
        try {
            Object mcEntity = ReflectionsHelper.getMCEntityFromBukkitEntity(toPlayEffect);
            Object mcPlayer = ReflectionsHelper.getMCEntityFromBukkitEntity((org.bukkit.entity.Entity)toSendTo);
            Method playOutAnnimation = mcPlayer.getClass().getDeclaredMethod("b", Class.forName("net.minecraft.server." + this.CB_RELOCATION + ".Entity"));
            playOutAnnimation.invoke(mcPlayer, mcEntity);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void sendParticleEffect(ParticleEffects effect, Location loc, Vector width, float speed, int amount, Player player) {
        if (width == null) {
            width = new Vector();
        }
        player.spawnParticle(MC_1_9_R1_VollotileCode.castParticle(effect), loc.getX(), loc.getY(), loc.getZ(), amount, width.getX(), width.getY(), width.getZ(), (double)speed);
    }

    @Override
    public void sendCustomPayload(Player player, String channel, ByteBuf buffer) {
        PacketDataSerializer serializer = new PacketDataSerializer(buffer);
        PacketPlayOutCustomPayload packet = new PacketPlayOutCustomPayload(channel, serializer);
        ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)packet);
    }

    @Override
    public void makeArrowPickupable(Arrow arrow, boolean mayBePickedUp) {
        if (arrow == null) {
            return;
        }
        CraftArrow craftArrow = (CraftArrow)arrow;
        craftArrow.getHandle().fromPlayer = mayBePickedUp ? EntityArrow.PickupStatus.ALLOWED : EntityArrow.PickupStatus.DISALLOWED;
    }

    @Override
    public void setTabHeaderFooter(Player player, String header, String footer) {
        if (player == null) {
            return;
        }
        if (header == null) {
            header = "";
        }
        if (footer == null) {
            footer = "";
        }
        MC_1_9_R1_VollotileCode.initHeaderFooterField();
        PacketPlayOutPlayerListHeaderFooter packet = new PacketPlayOutPlayerListHeaderFooter();
        try {
            headerPacketField.set(packet, MC_1_9_R1_VollotileCode.textToChatBase(header));
            footerPacketField.set(packet, MC_1_9_R1_VollotileCode.textToChatBase(footer));
        }
        catch (Throwable exp) {
            exp.printStackTrace();
        }
        ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)new PacketPlayOutPlayerListHeaderFooter());
    }

    private static IChatBaseComponent textToChatBase(String text) {
        String compiledText = text.isEmpty() ? "{\"translate\":\"\"}" : "{\"text\":\"" + text + "\"}";
        return IChatBaseComponent.ChatSerializer.a((String)compiledText);
    }

    private static void initHeaderFooterField() {
        if (footerPacketField != null) {
            return;
        }
        try {
            headerPacketField = PacketPlayOutPlayerListHeaderFooter.class.getDeclaredField("a");
            headerPacketField.setAccessible(true);
            footerPacketField = PacketPlayOutPlayerListHeaderFooter.class.getDeclaredField("b");
            footerPacketField.setAccessible(true);
        }
        catch (Throwable exp) {
            exp.printStackTrace();
        }
    }

    private static Particle castParticle(ParticleEffects effect) {
        switch (effect) {
            case ANGRY_VILLAGER: {
                return Particle.VILLAGER_ANGRY;
            }
            case BUBBLE: {
                return Particle.WATER_BUBBLE;
            }
            case CLOUD: {
                return Particle.CLOUD;
            }
            case CRIT: {
                return Particle.CRIT;
            }
            case DEPTH_SUSPEND: {
                return Particle.SUSPENDED_DEPTH;
            }
            case DRIP_LAVA: {
                return Particle.DRIP_LAVA;
            }
            case DRIP_WATER: {
                return Particle.DRIP_WATER;
            }
            case ENCHANTMENT_TABLE: {
                return Particle.ENCHANTMENT_TABLE;
            }
            case EXPLODE: {
                return Particle.EXPLOSION_NORMAL;
            }
            case FIREWORKS_SPARK: {
                return Particle.FIREWORKS_SPARK;
            }
            case FLAME: {
                return Particle.FLAME;
            }
            case FOOTSTEP: {
                return Particle.FOOTSTEP;
            }
            case HAPPY_VILLAGER: {
                return Particle.VILLAGER_HAPPY;
            }
            case HEART: {
                return Particle.HEART;
            }
            case HUGE_EXPLOSION: {
                return Particle.EXPLOSION_HUGE;
            }
            case INSTANT_SPELL: {
                return Particle.SPELL_INSTANT;
            }
            case LARGE_EXPLODE: {
                return Particle.EXPLOSION_LARGE;
            }
            case LARGE_SMOKE: {
                return Particle.SMOKE_LARGE;
            }
            case LAVA: {
                return Particle.LAVA;
            }
            case MAGIC_CRIT: {
                return Particle.CRIT_MAGIC;
            }
            case MOB_SPELL: {
                return Particle.SPELL_MOB;
            }
            case MOB_SPELL_AMBIENT: {
                return Particle.SPELL_MOB_AMBIENT;
            }
            case NOTE: {
                return Particle.NOTE;
            }
            case PORTAL: {
                return Particle.PORTAL;
            }
            case RED_DUST: {
                return Particle.REDSTONE;
            }
            case SLIME: {
                return Particle.SLIME;
            }
            case SNOWBALL_POOF: {
                return Particle.SNOWBALL;
            }
            case SNOW_SHOVEL: {
                return Particle.SNOW_SHOVEL;
            }
            case SPELL: {
                return Particle.SPELL;
            }
            case SPLASH: {
                return Particle.WATER_SPLASH;
            }
            case SUSPEND: {
                return Particle.SUSPENDED;
            }
            case TOWN_AURA: {
                return Particle.TOWN_AURA;
            }
            case WITCH_MAGIC: {
                return Particle.SPELL_WITCH;
            }
        }
        return Particle.CRIT;
    }

    @Override
    public void overwriteAIToDoNothing(LivingEntity entity) {
        CraftEntity lEntity = (CraftEntity)entity;
        Entity eLiving = lEntity.getHandle();
        if (eLiving instanceof EntityInsentient) {
            EntityInsentient iEntity = (EntityInsentient)eLiving;
            iEntity.m(true);
        }
    }

    @Override
    public void sendRawMessage(Player player, String rawMessage) {
        ((CraftPlayer)player).getHandle().sendMessage(IChatBaseComponent.ChatSerializer.a((String)rawMessage));
    }

    @Override
    public VollotileCode.MCVersion getVersion() {
        return VollotileCode.MCVersion.v1_9_R1;
    }

    @Override
    public void editBookToPages(ItemStack book, List<TellRawChatMessage> pages) {
        if (book == null || book.getType() != Material.WRITTEN_BOOK) {
            return;
        }
        try {
            BookMeta meta = (BookMeta)book.getItemMeta();
            Field field = null;
            block2: for (Class<?> clazz = meta.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                for (Field declared : clazz.getDeclaredFields()) {
                    if (!declared.getName().equals("pages")) continue;
                    field = declared;
                    declared.setAccessible(true);
                    continue block2;
                }
                if (field == null) continue;
            }
            if (field == null) {
                return;
            }
            List metaPages = (List)field.get(meta);
            for (TellRawChatMessage page : pages) {
                metaPages.add(IChatBaseComponent.ChatSerializer.a((String)page.buildBook()));
            }
            book.setItemMeta((ItemMeta)meta);
        }
        catch (Throwable exp) {
            exp.printStackTrace();
        }
    }

    @Override
    public void sendActionBarMessage(Player player, String message) {
        if (!player.isOnline()) {
            return;
        }
        try {
            PacketPlayOutChat packet = new PacketPlayOutChat(IChatBaseComponent.ChatSerializer.a((String)("{\"text\": \"" + message + "\"}")), 2);
            ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)packet);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public boolean entityWalkToLocation(LivingEntity entity, Location location, double speed) {
        try {
            EntityInsentient nmsEntity = (EntityInsentient)((CraftLivingEntity)entity).getHandle();
            PathEntity path = nmsEntity.getNavigation().a(new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ()));
            nmsEntity.getNavigation().a(path, speed);
            return true;
        }
        catch (Throwable exp) {
            return false;
        }
    }

    @Override
    public ItemStack removeAttackDamageTag(ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        item.setItemMeta(meta);
        return item;
    }

    @Override
    public void resetTitle(Player player) {
        PlayerConnection pc = ((CraftPlayer)player).getHandle().playerConnection;
        PacketPlayOutTitle titlePacket = new PacketPlayOutTitle(PacketPlayOutTitle.EnumTitleAction.RESET, null);
        pc.sendPacket((Packet)titlePacket);
    }

    @Override
    public void sendTitle(Player player, String title, String subtitle) {
        JsonObject obj;
        title = ChatColor.translateAlternateColorCodes((char)'&', (String)title);
        subtitle = ChatColor.translateAlternateColorCodes((char)'&', (String)subtitle);
        PlayerConnection pc = ((CraftPlayer)player).getHandle().playerConnection;
        if (title != null && !title.isEmpty()) {
            obj = new JsonObject();
            obj.addProperty("text", title);
            PacketPlayOutTitle titlePacket = new PacketPlayOutTitle(PacketPlayOutTitle.EnumTitleAction.TITLE, IChatBaseComponent.ChatSerializer.a((String)obj.toString()));
            pc.sendPacket((Packet)titlePacket);
        }
        if (subtitle != null && !subtitle.isEmpty()) {
            obj = new JsonObject();
            obj.addProperty("text", subtitle);
            PacketPlayOutTitle titlePacket2 = new PacketPlayOutTitle(PacketPlayOutTitle.EnumTitleAction.SUBTITLE, IChatBaseComponent.ChatSerializer.a((String)obj.toString()));
            pc.sendPacket((Packet)titlePacket2);
        }
    }

    @Override
    public String getPlayerLanguage(Player player) {
        if (this.localeField == null) {
            try {
                Field field = EntityPlayer.class.getDeclaredField("locale");
                field.setAccessible(true);
                this.localeField = field;
            }
            catch (Throwable exp) {
                return "en_US";
            }
        }
        EntityPlayer ePl = ((CraftPlayer)player).getHandle();
        try {
            return this.localeField.get(ePl).toString();
        }
        catch (Throwable exp) {
            return "en_US";
        }
    }

    @Override
    public String generateItemIDString(ItemStack item) {
        if (item == null) {
            return "";
        }
        Item nmsMat = Item.getById((int)item.getType().getId());
        MinecraftKey key = (MinecraftKey)Item.REGISTRY.b((Object)nmsMat);
        return "\\\"" + key.toString() + "\\\"";
    }
}

