/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.vollotile;

import de.tobiyas.util.RaC.UtilsUsingPlugin;
import de.tobiyas.util.RaC.chat.components.TellRawChatMessage;
import de.tobiyas.util.RaC.player.PlayerUtils;
import de.tobiyas.util.RaC.vollotile.ParticleEffects;
import de.tobiyas.util.RaC.vollotile.ReflectionsHelper;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public abstract class VollotileCode {
    protected final String CB_RELOCATION;
    private final int maxRange = 4096;

    public VollotileCode(String relocationString) {
        this.CB_RELOCATION = relocationString;
    }

    public abstract void playCriticalHitEffect(Player var1, Entity var2);

    public void playCriticalHitEffect(Entity toPlayEffect) {
        for (Player player : toPlayEffect.getWorld().getPlayers()) {
            if (!(player.getLocation().distanceSquared(toPlayEffect.getLocation()) < 2500.0)) continue;
            this.playCriticalHitEffect(player, toPlayEffect);
        }
    }

    public void sendRawMessage(Player player, String rawMessage) {
        try {
            String seperator = ".";
            Object mcPlayer = ReflectionsHelper.getMCEntityFromBukkitEntity((Entity)player);
            Class<?> iChatBaseComponent = Class.forName("net" + seperator + "minecraft" + seperator + "server" + seperator + this.CB_RELOCATION + seperator + "IChatBaseComponent");
            Class<?> chatSerializer = Class.forName("net" + seperator + "minecraft" + seperator + "server" + seperator + this.CB_RELOCATION + seperator + "ChatSerializer");
            Method serialize = chatSerializer.getMethod("a", String.class);
            Object serializedMessage = serialize.invoke(null, rawMessage);
            Method sendMessage = mcPlayer.getClass().getMethod("sendMessage", iChatBaseComponent);
            sendMessage.invoke(mcPlayer, serializedMessage);
        }
        catch (Throwable exp) {
            player.sendMessage(rawMessage);
        }
    }

    public void removeParticleEffect(LivingEntity entity) {
        Object mcPlayer = ReflectionsHelper.getMCEntityFromBukkitEntity((Entity)entity);
        try {
            Field dataWatcher = mcPlayer.getClass().getField("datawatcher");
            Method method = dataWatcher.getClass().getMethod("watch", Integer.class, Object.class);
            method.invoke((Object)dataWatcher, 8, (byte)0);
            method.invoke((Object)dataWatcher, 7, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sendCustomPayload(Player player, String channel, String message) {
        ByteBuf buffer = Unpooled.buffer();
        buffer.writeBytes(message.getBytes(Charset.forName("UTF-8")));
        this.sendCustomPayload(player, channel, buffer);
    }

    public abstract void sendCustomPayload(Player var1, String var2, ByteBuf var3);

    public abstract void sendParticleEffect(ParticleEffects var1, Location var2, Vector var3, float var4, int var5, Player var6);

    public void setTabHeaderFooter(Player player, String header, String footer) {
    }

    public void sendParticleEffectToAll(ParticleEffects effect, Location loc, float data, int amount) {
        this.sendParticleEffectToAll(effect, loc, new Vector(1, 1, 1), data, amount);
    }

    public void sendParticleEffectToAll(ParticleEffects effect, Location loc, Vector width, float data, int amount) {
        this.sendParticleEffectToPlayers(effect, loc, width, data, amount, PlayerUtils.getOnlinePlayers());
    }

    public void sendParticleEffectToPlayers(ParticleEffects effect, Location loc, Vector width, float data, int amount, Player ... players) {
        this.sendParticleEffectToPlayers(effect, loc, width, data, amount, Arrays.asList(players));
    }

    public void sendParticleEffectToPlayers(ParticleEffects effect, Location loc, Vector width, float data, int amount, Collection<Player> players) {
        for (Player player : players) {
            if (player.getLocation().getWorld() != loc.getWorld() || player.getLocation().distanceSquared(loc) > 4096.0) continue;
            this.sendParticleEffect(effect, loc, width, data, amount, player);
        }
    }

    public void sendParticleEffectsTo(ParticleEffects effect, Collection<Location> locations, Vector width, float data, int amount, Collection<Player> players) {
        for (Location loc : locations) {
            this.sendParticleEffectToPlayers(effect, loc, width, data, amount, players);
        }
    }

    public void sendParticleEffectsTo(ParticleEffects effect, Collection<Location> locations, Vector width, float data, int amount, Player ... players) {
        this.sendParticleEffectsTo(effect, locations, width, data, amount, Arrays.asList(players));
    }

    public abstract void makeArrowPickupable(Arrow var1, boolean var2);

    public boolean isCorrectVersion() {
        try {
            String seperator = ".";
            Class<?> clazz = Class.forName("net" + seperator + "minecraft" + seperator + "server" + seperator + this.CB_RELOCATION + seperator + "Entity");
            return clazz != null;
        }
        catch (ClassNotFoundException exp) {
            return false;
        }
    }

    public void setSkinOfPlayer(UtilsUsingPlugin plugin, Player player, String skin, String name) {
    }

    public abstract void overwriteAIToDoNothing(LivingEntity var1);

    public abstract MCVersion getVersion();

    public void editBookToPages(ItemStack book, List<TellRawChatMessage> pages) {
    }

    public void sendActionBarMessage(Player player, String message) {
    }

    public boolean entityWalkToLocation(LivingEntity entity, Location location, double speed) {
        return false;
    }

    public ItemStack removeAttackDamageTag(ItemStack item) {
        return item;
    }

    public String convertToTellraw(String unconverted) {
        return TellRawChatMessage.parse(unconverted).toString();
    }

    public void sendTitle(Player player, String title, String subtitle) {
    }

    public void resetTitle(Player player) {
    }

    public String toString() {
        return "Vollotile: " + this.CB_RELOCATION;
    }

    public String generateItemIDString(ItemStack item) {
        if (item == null) {
            return "";
        }
        return String.valueOf(item.getType().getId());
    }

    public String getPlayerLanguage(Player player) {
        return "en_US";
    }

    public static enum MCVersion {
        unknown,
        v1_6_R1,
        v1_6_R2,
        v1_6_R3,
        v1_7_R1,
        v1_7_R2,
        v1_7_R3,
        v1_7_R4,
        v1_8_R1,
        v1_8_R2,
        v1_8_R3,
        v1_9_R1,
        v1_9_R2,
        v1_10_R1,
        v1_11_R1,
        v1_12_R1;


        public boolean isVersionGreaterOrEqual(MCVersion version) {
            return this.ordinal() >= version.ordinal();
        }

        public boolean hasArmorstands() {
            return this.isVersionGreaterOrEqual(v1_8_R1);
        }

        public boolean hasActionBar() {
            return this.isVersionGreaterOrEqual(v1_8_R1);
        }

        public boolean hasTitle() {
            return this.isVersionGreaterOrEqual(v1_8_R1);
        }

        public boolean hasTellRawSupport() {
            return this.isVersionGreaterOrEqual(v1_7_R3);
        }
    }
}

