/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.time;

import de.tobiyas.util.RaC.time.TimeNameConstants;
import java.util.Arrays;
import java.util.Collection;

public class TimeContainer {
    private final int days;
    private final int hours;
    private final int minutes;
    private final int seconds;
    private final int miliseconds;
    private TimeNameConstants constants = TimeNameConstants.ENGLISH_CONSTANTS;

    public TimeContainer(int days, int hours, int minutes, int seconds, int miliseconds) {
        this.days = days;
        this.hours = hours;
        this.minutes = minutes;
        this.seconds = seconds;
        this.miliseconds = miliseconds;
    }

    public TimeContainer(int hours, int minutes, int seconds, int miliseconds) {
        this(0, hours, minutes, seconds, miliseconds);
    }

    public TimeContainer(int minutes, int seconds, int miliseconds) {
        this(0, minutes, seconds, miliseconds);
    }

    public TimeContainer(int seconds, int miliseconds) {
        this(0, seconds, miliseconds);
    }

    public TimeContainer(int miliseconds) {
        this(0, miliseconds);
    }

    public TimeContainer() {
        this(0);
    }

    public int getDays() {
        return this.days;
    }

    public int getHours() {
        return this.hours;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public int getMiliseconds() {
        return this.miliseconds;
    }

    public TimeContainer setConstants(TimeNameConstants constants) {
        if (constants != null) {
            this.constants = constants;
        }
        return this;
    }

    public String toString(TimeToDisplay ... toDisplay) {
        TimeContainer newContainer = this.changeToDisplayTypes(Arrays.asList(toDisplay));
        return newContainer.toString();
    }

    private TimeContainer changeToDisplayTypes(Collection<TimeToDisplay> toDisplay) {
        if (toDisplay.contains((Object)TimeToDisplay.All)) {
            return this;
        }
        int newDays = this.days;
        int newHours = this.hours;
        int newMinutes = this.minutes;
        int newSeconds = this.seconds;
        int newMiliseconds = this.miliseconds;
        if (!toDisplay.contains((Object)TimeToDisplay.Days)) {
            newHours += newDays * 24;
            newDays = 0;
        }
        if (!toDisplay.contains((Object)TimeToDisplay.Hours)) {
            newMinutes += newHours * 60;
            newHours = 0;
        }
        if (!toDisplay.contains((Object)TimeToDisplay.Minutes)) {
            newSeconds += newMinutes * 60;
            newMinutes = 0;
        }
        if (!toDisplay.contains((Object)TimeToDisplay.Seconds)) {
            newMiliseconds += newSeconds * 1000;
            newSeconds = 0;
        }
        if (!toDisplay.contains((Object)TimeToDisplay.Miliseconds)) {
            newMiliseconds = 0;
        }
        return new TimeContainer(newDays, newHours, newMinutes, newSeconds, newMiliseconds).setConstants(this.constants);
    }

    public String toString() {
        boolean hasDays = this.days > 0;
        boolean hasHours = this.hours > 0;
        boolean hasMinutes = this.minutes > 0;
        boolean hasSeconds = this.seconds > 0;
        boolean hasMiliseconds = this.miliseconds > 0;
        StringBuilder builder = new StringBuilder();
        if (hasDays) {
            builder.append(this.days + " " + this.constants.getDaysByNumber(this.days) + ", ");
        }
        if (hasHours) {
            builder.append(this.hours + " " + this.constants.getHoursByNumber(this.hours) + ", ");
        }
        if (hasMinutes) {
            builder.append(this.minutes + " " + this.constants.getMinutesByNumber(this.minutes) + ", ");
        }
        if (hasSeconds) {
            builder.append(this.seconds + " " + this.constants.getSecondsByNumber(this.seconds) + ", ");
        }
        if (hasMiliseconds) {
            builder.append(this.miliseconds + " " + this.constants.getMilisecondsByNumber(this.miliseconds) + ", ");
        }
        if (builder.length() <= 2) {
            builder.append("  ");
        }
        return builder.substring(0, builder.length() - 2);
    }

    public int hashCode() {
        return this.miliseconds + 1000 * this.seconds + 60000 * this.minutes + 3600000 * this.hours + 86400000 * this.days;
    }

    public static enum TimeToDisplay {
        Days,
        Hours,
        Minutes,
        Seconds,
        Miliseconds,
        All;

    }
}

