/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.sql;

import de.tobiyas.util.RaC.UtilsUsingPlugin;
import de.tobiyas.util.RaC.sql.SQL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

public class SQLConnectionManager {
    private UtilsUsingPlugin plugin;
    private String connectionString;
    private Connection connection = null;
    private String serverName;
    private String serverPort;
    private String serverDB;
    private String username;
    private String password;
    private final double SCALING_FACTOR = 40.0;
    private final long MIN_WAIT = 500000000L;
    private final long MAX_WAIT = 300000000000L;
    private final int VALID_TIMEOUT = 3;
    private long nextReconnectTimestamp = 0L;
    private int reconnectAttempt = 0;

    public SQLConnectionManager(UtilsUsingPlugin plugin, SQL.SQLProperties properties) {
        this.username = properties.userName;
        this.password = properties.password;
        this.serverName = properties.serverName;
        this.serverPort = properties.serverPort;
        this.serverDB = properties.serverDB;
        this.plugin = plugin;
    }

    public boolean checkConnected() {
        boolean exists;
        boolean isClosed = true;
        boolean isValid = false;
        boolean bl = exists = this.connection != null;
        if (this.nextReconnectTimestamp > 0L && this.nextReconnectTimestamp > System.nanoTime()) {
            return false;
        }
        if (exists) {
            try {
                isClosed = this.connection.isClosed();
            }
            catch (SQLException e) {
                isClosed = true;
                e.printStackTrace();
                this.plugin.getDebugLogger().logStackTrace(e);
            }
            if (!isClosed) {
                try {
                    isValid = this.connection.isValid(3);
                }
                catch (SQLException e) {
                    isValid = false;
                }
            }
        }
        if (exists && !isClosed && isValid) {
            this.nextReconnectTimestamp = 0L;
            this.reconnectAttempt = 0;
            return true;
        }
        if (exists && !isClosed) {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        this.connect();
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                if (this.reconnectAttempt > 1) {
                    this.checkConnected();
                }
                this.nextReconnectTimestamp = 0L;
                this.reconnectAttempt = 0;
                return true;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.plugin.getDebugLogger().logStackTrace(e);
        }
        ++this.reconnectAttempt;
        this.nextReconnectTimestamp = (long)((double)System.nanoTime() + Math.min(3.0E11, (double)this.reconnectAttempt * 40.0 * 5.0E8));
        return false;
    }

    private void connect() {
        block4: {
            this.connectionString = "jdbc:mysql://" + this.serverName + ":" + this.serverPort + "/" + this.serverDB;
            try {
                this.plugin.getDebugLogger().log("Attempting connection to MySQL...");
                Class.forName("com.mysql.jdbc.Driver");
                Properties connectionProperties = new Properties();
                connectionProperties.put("user", this.username);
                connectionProperties.put("password", this.password);
                connectionProperties.put("autoReconnect", "false");
                connectionProperties.put("maxReconnects", "0");
                this.connection = DriverManager.getConnection(this.connectionString, connectionProperties);
                this.plugin.getDebugLogger().log("Connection to MySQL was a success!");
            }
            catch (SQLException ex) {
                this.connection = null;
                if (this.reconnectAttempt == 0 || this.reconnectAttempt >= 11) {
                    this.plugin.getDebugLogger().logError("Connection to MySQL failed!");
                    this.plugin.getDebugLogger().logStackTrace(ex);
                }
            }
            catch (ClassNotFoundException ex) {
                this.connection = null;
                if (this.reconnectAttempt != 0 && this.reconnectAttempt < 11) break block4;
                this.plugin.getDebugLogger().logError("MySQL database driver not found!");
            }
        }
    }
}

