/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.schedule;

import de.tobiyas.Statistics;
import java.util.logging.Level;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public abstract class DebugBukkitRunnable
extends BukkitRunnable {
    private final String name;
    private Plugin plugin;
    private boolean sync = true;

    public DebugBukkitRunnable(String name) {
        this.name = name == null ? "UNKNOWN" : name;
    }

    public DebugBukkitRunnable() {
        this.name = ((Object)((Object)this)).getClass().getSimpleName();
    }

    public final void run() {
        long startMS = System.currentTimeMillis();
        long startNano = System.nanoTime();
        try {
            this.runIntern();
        }
        catch (Throwable exp) {
            String name = this.name == null ? "unknown" : this.name;
            String pluginName = this.plugin == null ? "unknown-plugin" : this.plugin.getName();
            String message = String.format("Error in Runnable '%s' in plugin '%s'", name, pluginName);
            this.plugin.getLogger().log(Level.WARNING, message, exp);
        }
        startMS = System.currentTimeMillis() - startMS;
        startNano = System.nanoTime() - startNano;
        if (this.plugin != null) {
            try {
                Statistics.log(this.plugin, this.sync, this.name, startMS, startNano);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected abstract void runIntern();

    public synchronized BukkitTask runTask(Plugin plugin) throws IllegalArgumentException, IllegalStateException {
        return super.runTask(plugin);
    }

    public synchronized BukkitTask runTaskAsynchronously(Plugin plugin) throws IllegalArgumentException, IllegalStateException {
        this.plugin = plugin;
        this.sync = false;
        return super.runTaskAsynchronously(plugin);
    }

    public synchronized BukkitTask runTaskLater(Plugin plugin, long delay) throws IllegalArgumentException, IllegalStateException {
        this.plugin = plugin;
        this.sync = true;
        return super.runTaskLater(plugin, delay);
    }

    public synchronized BukkitTask runTaskLaterAsynchronously(Plugin plugin, long delay) throws IllegalArgumentException, IllegalStateException {
        this.plugin = plugin;
        this.sync = false;
        return super.runTaskLaterAsynchronously(plugin, delay);
    }

    public synchronized BukkitTask runTaskTimer(Plugin plugin, long delay, long period) throws IllegalArgumentException, IllegalStateException {
        this.plugin = plugin;
        this.sync = true;
        return super.runTaskTimer(plugin, delay, period);
    }

    public synchronized BukkitTask runTaskTimerAsynchronously(Plugin plugin, long delay, long period) throws IllegalArgumentException, IllegalStateException {
        this.plugin = plugin;
        this.sync = false;
        return super.runTaskTimerAsynchronously(plugin, delay, period);
    }
}

