/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.quickbarconfiger.defaultbars;

import de.tobiyas.util.RaC.autocomplete.AutoCompleteUtils;
import de.tobiyas.util.RaC.quickbarconfiger.Bar;
import de.tobiyas.util.RaC.quickbarconfiger.BarHandler;
import java.util.Collection;
import java.util.HashSet;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerChatTabCompleteEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class BarStringChooser
extends Bar
implements Listener {
    private final StringChosenCallback callback;
    private final String oldValue;
    private String currentValue;
    private final Collection<String> autoCompletes = new HashSet<String>();

    public BarStringChooser(JavaPlugin plugin, BarHandler barHandler, Player player, String oldValue, StringChosenCallback callback) {
        this(plugin, barHandler, player, oldValue, callback, null);
    }

    public BarStringChooser(JavaPlugin plugin, BarHandler barHandler, Player player, String oldValue, StringChosenCallback callback, Collection<String> autoCompletes) {
        super(barHandler, player);
        this.oldValue = oldValue;
        this.currentValue = oldValue;
        this.callback = callback;
        if (autoCompletes != null) {
            this.autoCompletes.addAll(autoCompletes);
        }
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        player.sendMessage(ChatColor.GREEN + "Neuen Text eingeben und auf " + ChatColor.LIGHT_PURPLE + "APPLY" + ChatColor.GREEN + " dr\u00fccken!");
    }

    @Override
    protected void updateItemsIntern() {
        this.clickList.set(0, new Bar.ItemClickBi(BarStringChooser.generateItem(Material.WOOL, DyeColor.GREEN.getWoolData(), ChatColor.GREEN + "Apply", ChatColor.GREEN + "Nimmt den Aktuellen Wert."), new Bar.ItemClickedCallback(){

            @Override
            public void itemClicked(boolean shift, Block block) {
                BarStringChooser.this.applyString();
            }
        }));
        this.clickList.set(3, new Bar.ItemShowBi(BarStringChooser.generateItem(Material.WOOL, DyeColor.BLUE.getWoolData(), ChatColor.AQUA + "Value: " + this.currentValue, ChatColor.AQUA + "Der aktuelle Wert:", this.currentValue)));
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onChat(AsyncPlayerChatEvent event) {
        if (event.getPlayer() != this.player) {
            return;
        }
        String name = event.getMessage();
        if ("none".equalsIgnoreCase(name) || "kein".equalsIgnoreCase(name)) {
            name = "";
        }
        this.player.sendMessage(ChatColor.GREEN + "Neuer Text: " + name);
        this.currentValue = name;
        event.setFormat("");
        event.setMessage("");
        event.setCancelled(true);
        this.redraw();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPreChat(PlayerCommandPreprocessEvent event) {
        if (event.getPlayer() != this.player) {
            return;
        }
        String name = event.getMessage();
        if ("none".equalsIgnoreCase(name) || "kein".equalsIgnoreCase(name)) {
            name = "";
        }
        this.player.sendMessage(ChatColor.GREEN + "Neuer Text: " + name);
        this.currentValue = name;
        event.setMessage("");
        event.setCancelled(true);
        this.redraw();
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onChatAutoComplete(PlayerChatTabCompleteEvent event) {
        if (event.getPlayer() != this.player) {
            return;
        }
        String token = event.getLastToken();
        event.getTabCompletions().clear();
        event.getTabCompletions().addAll(AutoCompleteUtils.getAllNamesWith(this.autoCompletes, token));
    }

    protected void applyString() {
        HandlerList.unregisterAll((Listener)this);
        this.callback.newStringChosen(false, this.oldValue, this.currentValue);
        this.barHandler.backPressed();
    }

    @Override
    protected void back(boolean shift, Block unused) {
        HandlerList.unregisterAll((Listener)this);
        this.callback.newStringChosen(true, this.oldValue, this.oldValue);
        super.back(shift, unused);
    }

    public static interface StringChosenCallback {
        public void newStringChosen(boolean var1, String var2, String var3);
    }
}

