/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.quickbarconfiger.defaultbars;

import de.tobiyas.util.RaC.quickbarconfiger.Bar;
import de.tobiyas.util.RaC.quickbarconfiger.BarHandler;
import de.tobiyas.util.RaC.quickbarconfiger.defaultbars.AbstractMultiBar;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.potion.PotionEffectType;

public class BarPotionChooser
extends AbstractMultiBar
implements Listener {
    private final PotionChooserCallback callback;
    private final PotionEffectType oldValue;

    public BarPotionChooser(BarHandler barHandler, Player player, PotionEffectType oldValue, PotionChooserCallback callback) {
        super((int)Math.ceil((double)PotionEffectType.values().length / 6.0), barHandler, player);
        this.oldValue = oldValue;
        this.callback = callback;
    }

    @Override
    protected void updateLayer(int currentLayer) {
        int start = currentLayer * 6;
        for (int i = 0; i < 6; ++i) {
            this.clickList.set(i + 1, new PotionTypeEffectCallback(PotionEffectType.values()[start + i]));
        }
    }

    @Override
    protected void back(boolean shift, Block unused) {
        this.callback.newPotionChosen(true, this.oldValue, this.oldValue);
        super.back(shift, unused);
    }

    public static interface PotionChooserCallback {
        public void newPotionChosen(boolean var1, PotionEffectType var2, PotionEffectType var3);
    }

    private class PotionTypeEffectCallback
    extends Bar.ItemClickBi {
        public PotionTypeEffectCallback(final PotionEffectType type) {
            super(BarPotionChooser.generateItem(Material.POTION, (short)0, "Typ: " + (type == null ? "KEINE" : type.getName()), new String[]{"\u00c4ndert den Typen auf diesen."}), new Bar.ItemClickedCallback(){

                @Override
                public void itemClicked(boolean shift, Block block) {
                    BarPotionChooser.this.callback.newPotionChosen(false, BarPotionChooser.this.oldValue, type);
                    BarPotionChooser.this.barHandler.backPressed();
                }
            });
        }
    }
}

