/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.quickbarconfiger.defaultbars;

import de.tobiyas.util.RaC.quickbarconfiger.Bar;
import de.tobiyas.util.RaC.quickbarconfiger.BarHandler;
import java.util.Arrays;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class BarMaterialChooser
extends Bar {
    private static final List<Material> canNotBeShown = Arrays.asList(Material.WATER, Material.STATIONARY_WATER, Material.LAVA, Material.STATIONARY_LAVA, Material.BED_BLOCK, Material.PISTON_EXTENSION, Material.PISTON_MOVING_PIECE, Material.DOUBLE_STEP, Material.IRON_DOOR_BLOCK, Material.REDSTONE_WIRE, Material.CROPS, Material.SOIL, Material.BURNING_FURNACE, Material.FIRE, Material.SIGN_POST, Material.WOODEN_DOOR);
    private final List<Material> toChooseFrom;
    private final MaterialChangedCallback callback;
    private int startSlot = 0;

    public BarMaterialChooser(BarHandler barHandler, Player player, MaterialChangedCallback callback, List<Material> toChooseFrom) {
        super(barHandler, player);
        this.callback = callback;
        this.toChooseFrom = toChooseFrom;
    }

    @Override
    protected void updateItemsIntern() {
        ItemStack itemPrev = BarMaterialChooser.generateItem(Material.ARROW, (short)0, ChatColor.GREEN + "Links", "Rotiere nach Links");
        ItemStack itemNext = BarMaterialChooser.generateItem(Material.ARROW, (short)0, ChatColor.GREEN + "Rechts", "Rotiere nach Rechts");
        for (int i = 0; i < 6; ++i) {
            int index = this.startSlot + i;
            if (index >= this.toChooseFrom.size()) continue;
            this.clickList.set(i + 1, new MaterialClickedCallback(this.toChooseFrom.get(index)));
        }
        if (this.startSlot != 0) {
            this.clickList.set(0, new Bar.ItemClickBi(itemPrev, new Bar.ItemClickedCallback(){

                @Override
                public void itemClicked(boolean shift, Block block) {
                    BarMaterialChooser.this.prev();
                }
            }));
        }
        if (this.startSlot + 6 <= this.toChooseFrom.size()) {
            this.clickList.set(7, new Bar.ItemClickBi(itemNext, new Bar.ItemClickedCallback(){

                @Override
                public void itemClicked(boolean shift, Block block) {
                    BarMaterialChooser.this.next();
                }
            }));
        }
    }

    private void prev() {
        this.startSlot = Math.max(0, this.startSlot - 1);
    }

    private void next() {
        this.startSlot = Math.max(0, this.startSlot - 1);
    }

    private static ItemStack generateItem(Material mat) {
        Material displayMat = canNotBeShown.contains(mat) ? Material.BARRIER : mat;
        ItemStack item = new ItemStack(displayMat);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(ChatColor.AQUA + mat.name());
        item.setItemMeta(meta);
        return item;
    }

    public static interface MaterialChangedCallback {
        public void materialChanged(Material var1);
    }

    private class MaterialClickedCallback
    extends Bar.ItemClickBi {
        public MaterialClickedCallback(Material mat) {
            super(BarMaterialChooser.generateItem(mat), new MatCallback(mat));
        }
    }

    private class MatCallback
    implements Bar.ItemClickedCallback {
        private final Material mat;

        public MatCallback(Material mat) {
            this.mat = mat;
        }

        @Override
        public void itemClicked(boolean shift, Block block) {
            BarMaterialChooser.this.callback.materialChanged(this.mat);
            BarMaterialChooser.this.back(shift, null);
        }
    }
}

