/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.quickbarconfiger.defaultbars;

import de.tobiyas.util.RaC.quickbarconfiger.Bar;
import de.tobiyas.util.RaC.quickbarconfiger.BarHandler;
import de.tobiyas.util.RaC.quickbarconfiger.defaultbars.AbstractMultiBar;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;

public class BarEntityTypeChooser
extends AbstractMultiBar
implements Listener {
    private final EntityTypeChooserCallback callback;
    private final EntityType oldValue;

    public BarEntityTypeChooser(BarHandler barHandler, Player player, EntityType oldValue, EntityTypeChooserCallback callback) {
        super((int)Math.ceil((double)EntityType.values().length / 6.0), barHandler, player);
        this.oldValue = oldValue;
        this.callback = callback;
    }

    @Override
    protected void updateLayer(int currentLayer) {
        int start = currentLayer * 6;
        for (int i = 0; i < 6; ++i) {
            this.clickList.set(i + 1, new EntityTypeCallback(EntityType.values()[start + i]));
        }
    }

    @Override
    protected void back(boolean shift, Block unused) {
        this.callback.newEntityTypeChosen(true, this.oldValue, this.oldValue);
        super.back(shift, unused);
    }

    public static interface EntityTypeChooserCallback {
        public void newEntityTypeChosen(boolean var1, EntityType var2, EntityType var3);
    }

    private class EntityTypeCallback
    extends Bar.ItemClickBi {
        public EntityTypeCallback(final EntityType type) {
            super(BarEntityTypeChooser.generateItem(Material.ANVIL, (short)0, "Typ: " + type.getName(), new String[]{"\u00c4ndert den Typen auf diesen."}), new Bar.ItemClickedCallback(){

                @Override
                public void itemClicked(boolean shift, Block block) {
                    BarEntityTypeChooser.this.callback.newEntityTypeChosen(false, BarEntityTypeChooser.this.oldValue, type);
                }
            });
        }
    }
}

