/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.quickbarconfiger;

import de.tobiyas.util.RaC.quickbarconfiger.Bar;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerPickupArrowEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class BarHandler
implements Listener {
    protected final Stack<Bar> barBackStack = new Stack();
    protected Bar currentBar;
    protected final Player player;
    protected List<ItemStack> oldHotBar = new ArrayList<ItemStack>(9);
    protected Map<UUID, Long> lastClickEvent = new HashMap<UUID, Long>();

    public BarHandler(Player player, JavaPlugin plugin) {
        this.player = player;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        for (int i = 0; i < 9; ++i) {
            this.oldHotBar.add(player.getInventory().getItem(i));
        }
    }

    public void backPressed() {
        if (this.barBackStack.isEmpty()) {
            this.exit();
        } else {
            this.currentBar = this.barBackStack.pop();
            this.updateCurrentBar();
        }
    }

    public void goToSubBar(Bar newBar) {
        if (newBar == null) {
            return;
        }
        if (this.currentBar != null) {
            this.barBackStack.push(this.currentBar);
        }
        this.currentBar = newBar;
        this.updateCurrentBar();
    }

    public void redrawCurrentBar() {
        this.updateCurrentBar();
    }

    public void forceClose() {
        for (Bar bar : this.barBackStack) {
            bar.forceClose();
        }
        if (this.currentBar != null) {
            this.currentBar.forceClose();
        }
        this.exit();
    }

    public boolean isRootView(Bar bar) {
        if (bar == null) {
            return false;
        }
        if (bar == this.currentBar && this.barBackStack.isEmpty()) {
            return true;
        }
        return this.barBackStack.get(0) == bar;
    }

    private void updateCurrentBar() {
        if (this.currentBar == null) {
            return;
        }
        this.currentBar.updateItems();
        List<ItemStack> toShow = this.currentBar.getItemsToShow();
        for (int i = 0; i < 9; ++i) {
            this.player.getInventory().setItem(i, toShow.get(i));
        }
    }

    @EventHandler
    public void doNotThrowAway(PlayerDropItemEvent event) {
        if (event.getPlayer() == this.player) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void doNotInventory(InventoryClickEvent event) {
        if (event.getView().getPlayer() == this.player) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void doNotPickup(PlayerPickupItemEvent event) {
        if (event.getPlayer() == this.player) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void doNotPickup(PlayerPickupArrowEvent event) {
        if (event.getPlayer() == this.player) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void playerClickedItem(PlayerInteractEvent event) {
        long last;
        if (event.isCancelled()) {
            return;
        }
        if (event.getPlayer() != this.player) {
            return;
        }
        event.setCancelled(true);
        long now = System.currentTimeMillis();
        if (this.lastClickEvent.containsKey(this.player.getUniqueId()) && now - (last = this.lastClickEvent.get(this.player.getUniqueId()).longValue()) < 100L) {
            return;
        }
        this.lastClickEvent.put(this.player.getUniqueId(), now);
        int slot = event.getPlayer().getInventory().getHeldItemSlot();
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK) {
            Block block = event.getClickedBlock();
            this.currentBar.slotPressed(slot, block);
        }
    }

    @EventHandler
    public void charLogout(PlayerQuitEvent event) {
        if (event.getPlayer() != this.player) {
            return;
        }
        this.forceClose();
    }

    private void exit() {
        HandlerList.unregisterAll((Listener)this);
        for (int i = 0; i < 9; ++i) {
            this.player.getInventory().setItem(i, this.oldHotBar.get(i));
        }
        this.currentBar = null;
        this.barBackStack.clear();
    }

    public boolean isActive() {
        return this.currentBar != null || !this.barBackStack.isEmpty();
    }
}

