/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.quickbarconfiger;

import de.tobiyas.util.RaC.collections.Bi;
import de.tobiyas.util.RaC.quickbarconfiger.BarHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public abstract class Bar {
    protected final ItemStack itemBack = Bar.generateItem(Material.WOOL, DyeColor.RED.getWoolData(), ChatColor.RED + "Zur\u00fcck", "Bringt dich zur\u00fcck");
    protected final ItemStack itemExit = Bar.generateItem(Material.WOOL, DyeColor.RED.getWoolData(), ChatColor.RED + "Schlie\u00dfen", "Schlie\u00dft die Bar.");
    protected final List<ItemClickBi> clickList = new ArrayList<ItemClickBi>(9);
    protected final Player player;
    protected final BarHandler barHandler;

    public Bar(BarHandler barHandler, Player player) {
        this.barHandler = barHandler;
        this.player = player;
        this.clearItems();
    }

    public void slotPressed(int slot, Block block) {
        boolean shift = this.player.isSneaking();
        ItemClickBi bi = this.clickList.get(slot);
        if (bi != null) {
            ((ItemClickedCallback)bi.getValue()).itemClicked(shift, block);
        }
    }

    public final void updateItems() {
        this.clearItems();
        this.updateItemsIntern();
        this.clickList.set(8, new ItemClickBi(this.barHandler.isRootView(this) ? this.itemExit : this.itemBack, new ItemClickedCallback(){

            @Override
            public void itemClicked(boolean shift, Block block) {
                Bar.this.back(shift, block);
            }
        }));
    }

    protected void back(boolean shift, Block unused) {
        this.barHandler.backPressed();
    }

    protected void forceClose() {
    }

    protected void clearItems() {
        this.clickList.clear();
        for (int i = 0; i < 9; ++i) {
            this.clickList.add(new EmptyItemBi());
        }
    }

    protected abstract void updateItemsIntern();

    public List<ItemStack> getItemsToShow() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>(9);
        for (ItemClickBi bi : this.clickList) {
            items.add((ItemStack)bi.getKey());
        }
        return items;
    }

    protected void redraw() {
        this.barHandler.redrawCurrentBar();
    }

    protected static ItemStack generateItem(Material material, short damageValue, String name, String ... lore) {
        ItemStack item = new ItemStack(material, 1, damageValue);
        ItemMeta meta = item.getItemMeta();
        if (name != null && !name.isEmpty()) {
            meta.setDisplayName(name);
        }
        if (lore.length > 0) {
            meta.setLore(Arrays.asList(lore));
        }
        item.setItemMeta(meta);
        return item;
    }

    public static interface ItemClickedCallback {
        public void itemClicked(boolean var1, Block var2);
    }

    public static class EmptyItemBi
    extends ItemShowBi {
        public EmptyItemBi() {
            super(null);
        }
    }

    public static class ItemShowBi
    extends ItemClickBi {
        public ItemShowBi(ItemStack val1) {
            super(val1, new ItemClickedCallback(){

                @Override
                public void itemClicked(boolean shift, Block block) {
                }
            });
        }
    }

    public static class ItemClickBi
    extends Bi<ItemStack, ItemClickedCallback> {
        public ItemClickBi(ItemStack val1, ItemClickedCallback val2) {
            super(val1, val2);
        }
    }
}

