/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.player;

import de.tobiyas.util.RaC.schedule.DebugBukkitRunnable;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PlayerUtils {
    public static OfflinePlayer getOfflinePlayer(String playerName) {
        Player player = PlayerUtils.getPlayer(playerName);
        if (player != null) {
            return player;
        }
        for (OfflinePlayer offlinePlayer : Bukkit.getOfflinePlayers()) {
            if (offlinePlayer == null || offlinePlayer.getName() == null || !offlinePlayer.getName().equalsIgnoreCase(playerName)) continue;
            return offlinePlayer;
        }
        return null;
    }

    public static Player getPlayer(String playerName) {
        for (Player player : PlayerUtils.getOnlinePlayers()) {
            if (!player.getName().equalsIgnoreCase(playerName) && !ChatColor.stripColor((String)player.getDisplayName()).equalsIgnoreCase(playerName)) continue;
            return player;
        }
        return null;
    }

    public static Collection<Player> getOnlinePlayers() {
        HashSet<Player> collection = new HashSet<Player>();
        try {
            if (Bukkit.class.getMethod("getOnlinePlayers", new Class[0]).getReturnType() == Collection.class) {
                for (Player player : (Collection)Bukkit.class.getMethod("getOnlinePlayers", new Class[0]).invoke(null, new Object[0])) {
                    collection.add(player);
                }
            } else {
                for (Player player : (Player[])Bukkit.class.getMethod("getOnlinePlayers", new Class[0]).invoke(null, new Object[0])) {
                    collection.add(player);
                }
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return collection;
    }

    public static void updateInvNextTick(final UUID player, Plugin plugin) {
        new DebugBukkitRunnable("PlayerUpdateInvTick"){

            @Override
            protected void runIntern() {
                Player pl = Bukkit.getPlayer((UUID)player);
                if (pl != null && pl.isOnline()) {
                    pl.updateInventory();
                }
            }
        }.runTaskLater(plugin, 1L);
    }

    public static Player getPlayer(UUID playerUUID) {
        if (playerUUID == null) {
            return null;
        }
        for (Player pl : PlayerUtils.getOnlinePlayers()) {
            if (!pl.getUniqueId().equals(playerUUID)) continue;
            return pl;
        }
        return null;
    }

    public static Collection<Player> getPlayersNear(Location location, double distance) {
        distance *= distance;
        HashSet<Player> players = new HashSet<Player>();
        if (location == null || distance <= 0.0) {
            return players;
        }
        World world = location.getWorld();
        for (Player player : world.getPlayers()) {
            if (!(player.getLocation().distanceSquared(location) < distance)) continue;
            players.add(player);
        }
        return players;
    }
}

