/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.persistence.file;

import de.tobiyas.util.RaC.config.YAMLConfigExtended;
import java.io.File;
import java.io.FilenameFilter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class YAMLPersistenceProvider {
    protected Map<String, YAMLConfigExtended> playerYamls = new HashMap<String, YAMLConfigExtended>();
    protected Set<String> knownPlayers;
    protected final File root;
    protected final JavaPlugin plugin;
    private static int cacheHit = 0;
    private static int cacheMiss = 0;
    private static YAMLPersistenceProvider provider;

    public YAMLPersistenceProvider(JavaPlugin plugin, String folder) {
        this.plugin = plugin;
        this.root = new File(plugin.getDataFolder(), folder);
        if (!this.root.exists()) {
            this.root.mkdirs();
        }
    }

    public YAMLPersistenceProvider(JavaPlugin plugin) {
        this(plugin, "PlayerData");
    }

    public YAMLConfigExtended getLoadedPlayerFile(String playerName) {
        return this.getLoadedPlayerFile(playerName, playerName);
    }

    public YAMLConfigExtended getLoadedPlayerFile(String playerName, String fileNameIfNotPresent) {
        if (this.knownPlayers == null) {
            this.rescanKnownPlayers();
        }
        if (this.playerYamls.containsKey(playerName)) {
            YAMLConfigExtended playerConfig = this.playerYamls.get(playerName);
            if (playerConfig.getValidLoad()) {
                ++cacheHit;
                return playerConfig;
            }
            ++cacheMiss;
            return playerConfig.load();
        }
        if (this.knownPlayers.contains(playerName)) {
            YAMLConfigExtended playerConfig = new YAMLConfigExtended(new File(this.root, fileNameIfNotPresent + ".yml")).load();
            this.playerYamls.put(playerName, playerConfig);
            ++cacheMiss;
            return playerConfig;
        }
        YAMLConfigExtended playerConfig = new YAMLConfigExtended(new File(this.root, fileNameIfNotPresent + ".yml")).load();
        this.playerYamls.put(playerName, playerConfig);
        this.rescanKnownPlayers();
        ++cacheMiss;
        return playerConfig;
    }

    public void remove(String name) {
        if (!this.playerYamls.containsKey(name)) {
            return;
        }
        YAMLConfigExtended config = this.getLoadedPlayerFile(name);
        config.getFileLoadFrom().delete();
        this.playerYamls.remove(name);
    }

    public Set<String> getAllPlayersKnown() {
        if (this.knownPlayers == null) {
            this.rescanKnownPlayers();
        }
        return this.knownPlayers;
    }

    public Set<String> getAllPlayersLoaded() {
        return new HashSet<String>(this.playerYamls.keySet());
    }

    protected void rescanKnownPlayers() {
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (name.startsWith("playerData")) {
                    return false;
                }
                return name.endsWith(".yml");
            }
        };
        if (this.knownPlayers == null) {
            this.knownPlayers = new HashSet<String>();
        }
        this.knownPlayers.clear();
        String[] playerFileNames = this.root.list(filter);
        if (playerFileNames == null) {
            return;
        }
        for (String playerFile : playerFileNames) {
            this.knownPlayers.add(playerFile.replace(".yml", ""));
        }
    }

    public void startAsyncSaving() {
        Bukkit.getScheduler().scheduleAsyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                for (YAMLConfigExtended config : YAMLPersistenceProvider.this.playerYamls.values()) {
                    if (!config.isDirty()) continue;
                    config.saveAsync();
                }
            }
        }, 1L);
    }

    public void startSyncSaving() {
        for (YAMLConfigExtended config : this.playerYamls.values()) {
            try {
                if (!config.isDirty()) continue;
                config.save();
            }
            catch (Throwable exp) {
                exp.printStackTrace();
            }
        }
    }

    public static double getCacheHitRate() {
        double total = cacheHit + cacheMiss;
        return total / (double)cacheHit;
    }

    public static int getTotalTries() {
        return cacheHit + cacheMiss;
    }

    public static void init(JavaPlugin plugin) {
        provider = new YAMLPersistenceProvider(plugin);
    }

    public static YAMLPersistenceProvider getProvider() {
        if (provider == null) {
            throw new NullPointerException("The YAMLPersistance Provider has NOT been inited!");
        }
        return provider;
    }
}

