/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.permissions.plugins;

import de.tobiyas.util.RaC.permissions.plugins.PermissionPlugin;
import de.tobiyas.yapp.API.GroupAPI;
import de.tobiyas.yapp.API.PlayerPermAPI;
import de.tobiyas.yapp.perm.Group;
import de.tobiyas.yapp.perm.PermPlayer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class YAPPPerms
implements PermissionPlugin {
    @Override
    public boolean isActive() {
        return Bukkit.getPluginManager().isPluginEnabled("YAPP");
    }

    @Override
    public boolean hasGroupSupport() {
        return true;
    }

    @Override
    public boolean hasSubgroupSupport() {
        return true;
    }

    @Override
    public boolean getPermissions(CommandSender sender, String permissionNode) {
        if (sender == Bukkit.getConsoleSender()) {
            return true;
        }
        if (sender instanceof Player) {
            return PlayerPermAPI.hasAnyPermission((UUID)((Player)sender).getUniqueId(), (String[])new String[]{permissionNode});
        }
        return false;
    }

    @Override
    @Deprecated
    public boolean getPermissions(String playerName, String permissionNode) {
        return false;
    }

    @Override
    public List<String> getGroups() {
        ArrayList<String> names = new ArrayList<String>();
        for (Group group : GroupAPI.getGroups()) {
            names.add(group.getName());
        }
        return names;
    }

    @Override
    public String getGroupOfPlayer(OfflinePlayer player) {
        PermPlayer pl = PlayerPermAPI.getPlayer((UUID)player.getUniqueId());
        Set groups = pl.getGroups();
        if (groups.isEmpty()) {
            return null;
        }
        return ((Group)groups.iterator().next()).getName();
    }

    @Override
    public void init() {
    }

    @Override
    public String getName() {
        return "YAPP";
    }

    @Override
    public void addPermission(OfflinePlayer player, String permission) {
        PlayerPermAPI.getPlayer((UUID)player.getUniqueId()).addSinglePerm(new String[]{permission});
    }

    @Override
    public void removePermission(OfflinePlayer player, String permission) {
        PlayerPermAPI.getPlayer((UUID)player.getUniqueId()).removeSinglePerm(new String[]{permission});
    }

    @Override
    public void addGroup(OfflinePlayer player, String group) {
        Group grp = GroupAPI.getGroupByName((String)group);
        if (grp != null) {
            PlayerPermAPI.getPlayer((UUID)player.getUniqueId()).addGroup(new Group[]{grp});
        }
    }

    @Override
    public void removeGroup(OfflinePlayer player, String group) {
        Group grp = GroupAPI.getGroupByName((String)group);
        if (grp != null) {
            PlayerPermAPI.getPlayer((UUID)player.getUniqueId()).removeGroup(new Group[]{grp});
        }
    }

    @Override
    public void addSubgroup(OfflinePlayer player, String subgroup) {
        this.addGroup(player, subgroup);
    }

    @Override
    public void removeSubgroup(OfflinePlayer player, String subgroup) {
        this.removeGroup(player, subgroup);
    }

    @Override
    public List<String> listSubgroups(OfflinePlayer player) {
        return this.getGroups();
    }
}

