/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.permissions.plugins;

import de.tobiyas.util.RaC.permissions.plugins.PermissionPlugin;
import de.tobiyas.util.RaC.player.PlayerUtils;
import java.util.ArrayList;
import java.util.List;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;

public class VaultPermissions
implements PermissionPlugin {
    private Permission vaultPermission;
    private boolean isActive = false;

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public boolean getPermissions(CommandSender sender, String permissionNode) {
        if (sender == null) {
            return false;
        }
        if (permissionNode == null || permissionNode == "") {
            return false;
        }
        if (!this.isActive()) {
            return false;
        }
        return this.vaultPermission.has(sender, permissionNode);
    }

    public ArrayList<String> getGroups() {
        ArrayList<String> groups = new ArrayList<String>();
        if (!this.isActive()) {
            return groups;
        }
        for (String group : this.vaultPermission.getGroups()) {
            groups.add(group);
        }
        return groups;
    }

    @Override
    public void init() {
        this.isActive = this.initVault();
    }

    private boolean initVault() {
        try {
            RegisteredServiceProvider permissionProvider = Bukkit.getServer().getServicesManager().getRegistration(Permission.class);
            if (permissionProvider != null) {
                this.vaultPermission = (Permission)permissionProvider.getProvider();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.vaultPermission != null;
    }

    @Override
    public String getGroupOfPlayer(OfflinePlayer player) {
        if (!this.isActive()) {
            return "";
        }
        return this.vaultPermission.getPrimaryGroup(null, player);
    }

    @Override
    public String getName() {
        return "Vault";
    }

    public Permission getHandle() {
        return this.vaultPermission;
    }

    @Override
    public boolean getPermissions(String playerName, String permissionNode) {
        Player player = PlayerUtils.getPlayer(playerName);
        if (player == null) {
            return false;
        }
        return this.getPermissions((CommandSender)player, permissionNode);
    }

    @Override
    public void addPermission(OfflinePlayer player, String permission) {
        this.vaultPermission.playerAdd(null, player, permission);
    }

    @Override
    public void removePermission(OfflinePlayer player, String permission) {
        this.vaultPermission.playerRemove(null, player, permission);
    }

    @Override
    public boolean hasGroupSupport() {
        return true;
    }

    @Override
    public boolean hasSubgroupSupport() {
        return false;
    }

    @Override
    public void addSubgroup(OfflinePlayer player, String subgroup) {
    }

    @Override
    public void removeSubgroup(OfflinePlayer player, String subgroup) {
    }

    @Override
    public void addGroup(OfflinePlayer player, String group) {
        Player rPlayer = player.getPlayer();
        if (rPlayer == null) {
            return;
        }
        this.vaultPermission.playerAddGroup(rPlayer, group);
    }

    @Override
    public void removeGroup(OfflinePlayer player, String group) {
        Player rPlayer = player.getPlayer();
        if (rPlayer == null) {
            return;
        }
        this.vaultPermission.playerRemoveGroup(rPlayer, group);
    }

    @Override
    public List<String> listSubgroups(OfflinePlayer player) {
        ArrayList<String> groups = new ArrayList<String>();
        if (!this.isActive()) {
            return groups;
        }
        for (String group : this.vaultPermission.getGroups()) {
            groups.add(group);
        }
        return groups;
    }
}

