/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.permissions.plugins;

import com.platymuus.bukkit.permissions.Group;
import com.platymuus.bukkit.permissions.PermissionsPlugin;
import de.tobiyas.util.RaC.UtilsUsingPlugin;
import de.tobiyas.util.RaC.permissions.plugins.PermissionPlugin;
import de.tobiyas.util.RaC.player.PlayerUtils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PermissionsBukkitPermissions
implements PermissionPlugin {
    private PermissionsPlugin permissions;
    private boolean isActive;
    private final UtilsUsingPlugin plugin;

    public PermissionsBukkitPermissions(UtilsUsingPlugin plugin) {
        this.plugin = plugin;
        this.isActive = false;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public boolean getPermissions(CommandSender sender, String permissionNode) {
        if (!this.isActive()) {
            return false;
        }
        if (sender == null) {
            return false;
        }
        if (!(sender instanceof Player)) {
            return true;
        }
        Player player = (Player)sender;
        return player.hasPermission(permissionNode);
    }

    public ArrayList<String> getGroups() {
        ArrayList<String> groups = new ArrayList<String>();
        if (!this.isActive()) {
            return groups;
        }
        for (Group group : this.permissions.getAllGroups()) {
            groups.add(group.getName());
        }
        return groups;
    }

    @Override
    public String getGroupOfPlayer(OfflinePlayer player) {
        if (!this.isActive()) {
            return "";
        }
        if (player == null) {
            return "";
        }
        if (this.permissions.getPlayerInfo(player.getName()).getGroups().size() == 0) {
            return "";
        }
        return ((Group)this.permissions.getPlayerInfo(player.getName()).getGroups().get(0)).getName();
    }

    @Override
    public void init() {
        this.isActive = this.initBPerms();
    }

    private boolean initBPerms() {
        try {
            PermissionsPlugin bPerm = (PermissionsPlugin)Bukkit.getServer().getPluginManager().getPlugin("PermissionsBukkit");
            if (bPerm == null) {
                return false;
            }
            this.permissions = bPerm;
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public String getName() {
        return "PermissionsBukkit";
    }

    @Override
    public boolean getPermissions(String playerName, String permissionNode) {
        Player player = PlayerUtils.getPlayer(playerName);
        if (player == null) {
            return false;
        }
        return this.getPermissions((CommandSender)player, permissionNode);
    }

    @Override
    public void addPermission(OfflinePlayer player, String permission) {
        if (player.isOnline()) {
            player.getPlayer().addAttachment((Plugin)this.plugin, permission, true);
        }
    }

    @Override
    public void removePermission(OfflinePlayer player, String permission) {
        if (player.isOnline()) {
            player.getPlayer().addAttachment((Plugin)this.plugin, permission, false);
        }
    }

    @Override
    public boolean hasGroupSupport() {
        return true;
    }

    @Override
    public boolean hasSubgroupSupport() {
        return true;
    }

    @Override
    public void addSubgroup(OfflinePlayer player, String subgroup) {
        this.plugin.getServer().dispatchCommand((CommandSender)Bukkit.getServer().getConsoleSender(), "permissions player addgroup " + player.getName() + " " + subgroup);
    }

    @Override
    public void removeSubgroup(OfflinePlayer player, String subgroup) {
        this.plugin.getServer().dispatchCommand((CommandSender)Bukkit.getServer().getConsoleSender(), "permissions player removegroup " + player.getName() + " " + subgroup);
    }

    @Override
    public void addGroup(OfflinePlayer player, String group) {
        this.plugin.getServer().dispatchCommand((CommandSender)Bukkit.getServer().getConsoleSender(), "permissions player addgroup " + player.getName() + " " + group);
    }

    @Override
    public void removeGroup(OfflinePlayer player, String group) {
        this.plugin.getServer().dispatchCommand((CommandSender)Bukkit.getServer().getConsoleSender(), "permissions player removegroup " + player.getName() + " " + group);
    }

    @Override
    public List<String> listSubgroups(OfflinePlayer player) {
        ArrayList<String> groups = new ArrayList<String>();
        if (!this.isActive()) {
            return groups;
        }
        for (Group group : this.permissions.getAllGroups()) {
            groups.add(group.getName());
        }
        return groups;
    }
}

