/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.permissions.plugins;

import de.tobiyas.util.RaC.permissions.plugins.PermissionPlugin;
import de.tobiyas.util.RaC.player.PlayerUtils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import ru.tehkode.permissions.PermissionGroup;
import ru.tehkode.permissions.bukkit.PermissionsEx;

public class PEXPermissions
implements PermissionPlugin {
    private PermissionsEx pexPlugin;
    private boolean isActive = false;

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public boolean getPermissions(CommandSender sender, String permissionNode) {
        if (!(sender instanceof Player)) {
            return true;
        }
        if (!this.isActive()) {
            return false;
        }
        Player player = (Player)sender;
        return this.pexPlugin.has(player, permissionNode);
    }

    public ArrayList<String> getGroups() {
        ArrayList<String> groups = new ArrayList<String>();
        if (!this.isActive()) {
            return groups;
        }
        List pexGroups = PermissionsEx.getPermissionManager().getGroupList();
        for (PermissionGroup pexGroup : pexGroups) {
            groups.add(pexGroup.getName());
        }
        return groups;
    }

    @Override
    public void init() {
        this.isActive = this.initPEX();
    }

    private boolean initPEX() {
        try {
            PermissionsEx pex = (PermissionsEx)Bukkit.getServer().getPluginManager().getPlugin("PermissionsEx");
            if (pex == null) {
                return false;
            }
            this.pexPlugin = pex;
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public String getGroupOfPlayer(OfflinePlayer player) {
        if (!this.isActive()) {
            return "";
        }
        if (PermissionsEx.getPermissionManager().getUser(player.getName()).getGroupsNames().length > 0) {
            return PermissionsEx.getPermissionManager().getUser(player.getName()).getGroupsNames()[0];
        }
        return "";
    }

    @Override
    public String getName() {
        return "PermissionsEx";
    }

    @Override
    public boolean getPermissions(String playerName, String permissionNode) {
        Player player = PlayerUtils.getPlayer(playerName);
        if (player == null) {
            return false;
        }
        return this.getPermissions((CommandSender)player, permissionNode);
    }

    @Override
    public void addPermission(OfflinePlayer player, String permission) {
        PermissionsEx.getPermissionManager().getUser(player.getName()).addPermission(permission);
    }

    @Override
    public void removePermission(OfflinePlayer player, String permission) {
        PermissionsEx.getPermissionManager().getUser(player.getName()).removePermission(permission);
    }

    @Override
    public boolean hasGroupSupport() {
        return true;
    }

    @Override
    public boolean hasSubgroupSupport() {
        return false;
    }

    @Override
    public void addSubgroup(OfflinePlayer player, String subgroup) {
        PermissionsEx.getPermissionManager().getUser(player.getName()).addGroup(subgroup);
    }

    @Override
    public void removeSubgroup(OfflinePlayer player, String subgroup) {
        PermissionsEx.getPermissionManager().getUser(player.getName()).removeGroup(subgroup);
    }

    @Override
    public void addGroup(OfflinePlayer player, String group) {
        PermissionsEx.getPermissionManager().getUser(player.getName()).addGroup(group);
    }

    @Override
    public void removeGroup(OfflinePlayer player, String group) {
        PermissionsEx.getPermissionManager().getUser(player.getName()).removeGroup(group);
    }

    @Override
    public List<String> listSubgroups(OfflinePlayer player) {
        ArrayList<String> groups = new ArrayList<String>();
        if (!this.isActive()) {
            return groups;
        }
        List pexGroups = PermissionsEx.getPermissionManager().getGroupList();
        for (PermissionGroup pexGroup : pexGroups) {
            groups.add(pexGroup.getName());
        }
        return groups;
    }
}

