/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.permissions.plugins;

import de.tobiyas.util.RaC.permissions.plugins.PermissionPlugin;
import de.tobiyas.util.RaC.player.PlayerUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.anjocaido.groupmanager.GroupManager;
import org.anjocaido.groupmanager.data.Group;
import org.anjocaido.groupmanager.permissions.AnjoPermissionsHandler;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class GroupManagerPermissions
implements PermissionPlugin {
    private GroupManager groupManager;
    private boolean isActive = false;

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public boolean getPermissions(CommandSender sender, String permissionNode) {
        if (!(sender instanceof Player)) {
            return true;
        }
        if (!this.isActive()) {
            return false;
        }
        Player player = (Player)sender;
        return this.hasPermissionGroupManager(player, permissionNode);
    }

    private boolean hasPermissionGroupManager(Player base, String node) {
        AnjoPermissionsHandler handler = this.groupManager.getWorldsHolder().getWorldPermissions(base);
        if (handler == null) {
            return false;
        }
        return handler.has(base, node);
    }

    public ArrayList<String> getGroups() {
        ArrayList<String> groups = new ArrayList<String>();
        if (!this.isActive()) {
            return groups;
        }
        Collection groupList = this.groupManager.getWorldsHolder().getDefaultWorld().getGroupList();
        for (Group group : groupList) {
            groups.add(group.getName());
        }
        return groups;
    }

    @Override
    public void init() {
        this.isActive = this.initGM();
    }

    private boolean initGM() {
        try {
            GroupManager gm = (GroupManager)Bukkit.getServer().getPluginManager().getPlugin("GroupManager");
            if (gm == null) {
                return false;
            }
            this.groupManager = gm;
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public String getGroupOfPlayer(OfflinePlayer player) {
        if (!this.isActive()) {
            return "";
        }
        Group group = this.groupManager.getWorldsHolder().getDefaultWorld().getDefaultGroup();
        if (group == null) {
            return "";
        }
        return group.getName();
    }

    @Override
    public String getName() {
        return "GroupManager";
    }

    @Override
    public boolean getPermissions(String playerName, String permissionNode) {
        Player player = PlayerUtils.getPlayer(playerName);
        if (player == null) {
            return false;
        }
        return this.getPermissions((CommandSender)player, permissionNode);
    }

    @Override
    public void addPermission(OfflinePlayer player, String permission) {
        this.groupManager.getWorldsHolder().getDefaultWorld().getUser(player.getName()).addPermission(permission);
    }

    @Override
    public void removePermission(OfflinePlayer player, String permission) {
        this.groupManager.getWorldsHolder().getDefaultWorld().getUser(player.getName()).removePermission(permission);
    }

    @Override
    public boolean hasGroupSupport() {
        return true;
    }

    @Override
    public boolean hasSubgroupSupport() {
        return true;
    }

    @Override
    public void addSubgroup(OfflinePlayer player, String subgroup) {
        Group subgroupObj = this.groupManager.getWorldsHolder().getDefaultWorld().getGroup(subgroup);
        if (subgroupObj == null) {
            return;
        }
        this.groupManager.getWorldsHolder().getDefaultWorld().getUser(player.getName()).addSubGroup(subgroupObj);
    }

    @Override
    public void removeSubgroup(OfflinePlayer player, String subgroup) {
        Group subgroupObj = this.groupManager.getWorldsHolder().getDefaultWorld().getGroup(subgroup);
        if (subgroupObj == null) {
            return;
        }
        this.groupManager.getWorldsHolder().getDefaultWorld().getUser(player.getName()).removeSubGroup(subgroupObj);
    }

    @Override
    public void addGroup(OfflinePlayer player, String group) {
        Group groupObj = this.groupManager.getWorldsHolder().getDefaultWorld().getGroup(group);
        if (groupObj == null) {
            return;
        }
        this.groupManager.getWorldsHolder().getDefaultWorld().getUser(player.getName()).setGroup(groupObj);
    }

    @Override
    public void removeGroup(OfflinePlayer player, String group) {
        Group groupObj = this.groupManager.getWorldsHolder().getDefaultWorld().getGroup(group);
        if (groupObj == null) {
            return;
        }
        this.groupManager.getWorldsHolder().getDefaultWorld().getUser(player.getName()).removeSubGroup(groupObj);
    }

    @Override
    public List<String> listSubgroups(OfflinePlayer player) {
        LinkedList<String> ret = new LinkedList<String>();
        for (Group group : this.groupManager.getWorldsHolder().getDefaultWorld().getGroupList()) {
            ret.add(group.getName());
        }
        return ret;
    }
}

