/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.permissions;

import de.tobiyas.util.RaC.UtilsUsingPlugin;
import de.tobiyas.util.RaC.permissions.plugins.BPermissionsPermissions;
import de.tobiyas.util.RaC.permissions.plugins.GroupManagerPermissions;
import de.tobiyas.util.RaC.permissions.plugins.OpPermissions;
import de.tobiyas.util.RaC.permissions.plugins.PEXPermissions;
import de.tobiyas.util.RaC.permissions.plugins.PermissionPlugin;
import de.tobiyas.util.RaC.permissions.plugins.PermissionsBukkitPermissions;
import de.tobiyas.util.RaC.permissions.plugins.VaultPermissions;
import de.tobiyas.util.RaC.permissions.plugins.YAPPPerms;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;

public class PermissionManager
implements PermissionPlugin {
    private PermissionPlugin permPlugin;
    private UtilsUsingPlugin plugin;

    public PermissionManager(UtilsUsingPlugin plugin, ArrayList<String> denialList) {
        this.plugin = plugin;
        this.permPlugin = this.checkForPermissionsPlugin(denialList);
    }

    public PermissionManager(UtilsUsingPlugin plugin) {
        this.plugin = plugin;
        this.permPlugin = this.checkForPermissionsPlugin(null);
    }

    private PermissionPlugin checkForPermissionsPlugin(ArrayList<String> denialList) {
        PermissionPlugin tempPlugin;
        if (denialList == null) {
            denialList = new ArrayList();
        }
        if (!this.containsStringIgnoreCase("YAPP", denialList)) {
            try {
                tempPlugin = new YAPPPerms();
                tempPlugin.init();
                if (tempPlugin.isActive()) {
                    return tempPlugin;
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        if (!this.containsStringIgnoreCase("Vault", denialList)) {
            try {
                tempPlugin = new VaultPermissions();
                tempPlugin.init();
                if (tempPlugin.isActive()) {
                    return tempPlugin;
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        if (!this.containsStringIgnoreCase("PermissionsEX", denialList)) {
            try {
                tempPlugin = new PEXPermissions();
                tempPlugin.init();
                if (tempPlugin.isActive()) {
                    return tempPlugin;
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        if (!this.containsStringIgnoreCase("GroupManager", denialList)) {
            try {
                tempPlugin = new GroupManagerPermissions();
                tempPlugin.init();
                if (tempPlugin.isActive()) {
                    return tempPlugin;
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        if (!this.containsStringIgnoreCase("PermissionsBukkit", denialList)) {
            try {
                tempPlugin = new PermissionsBukkitPermissions(this.plugin);
                tempPlugin.init();
                if (tempPlugin.isActive()) {
                    return tempPlugin;
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        if (!this.containsStringIgnoreCase("BPermissions", denialList)) {
            try {
                tempPlugin = new BPermissionsPermissions();
                tempPlugin.init();
                if (tempPlugin.isActive()) {
                    return tempPlugin;
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        tempPlugin = new OpPermissions();
        this.plugin.getLogger().log(Level.WARNING, "Info: No Permission-System hooked. Plugin will use Op-State to consider Permissions.");
        return tempPlugin;
    }

    private boolean containsStringIgnoreCase(String noCheck, List<String> list) {
        for (String name : list) {
            if (!name.equalsIgnoreCase(noCheck)) continue;
            return true;
        }
        return false;
    }

    private boolean checkPermissionsIntern(CommandSender sender, String permissionNode) {
        if (sender == null) {
            return false;
        }
        boolean hasPermissionsNormal = this.permPlugin.getPermissions(sender, permissionNode);
        boolean hasPermissionsLowercase = this.permPlugin.getPermissions(sender, permissionNode.toLowerCase());
        return hasPermissionsNormal || hasPermissionsLowercase;
    }

    public boolean checkPermissions(CommandSender sender, String permissionNode) {
        boolean perm = this.checkPermissionsIntern(sender, permissionNode);
        if (!perm) {
            sender.sendMessage(ChatColor.RED + "You don't have Permissions!");
        }
        return perm;
    }

    public boolean checkPermissionsSilent(CommandSender sender, String permissionNode) {
        return this.checkPermissionsIntern(sender, permissionNode);
    }

    public boolean checkPermissionsSilent(String playerName, String permissionNode) {
        return this.permPlugin.getPermissions(playerName, permissionNode);
    }

    public List<String> getAllGroups() {
        return this.permPlugin.getGroups();
    }

    @Override
    public String getGroupOfPlayer(OfflinePlayer player) {
        return this.permPlugin.getGroupOfPlayer(player);
    }

    public String getPermissionsName() {
        return this.permPlugin.getName();
    }

    public boolean hasAnyPermissionSilent(CommandSender sender, String[] permissions) {
        for (String perm : permissions) {
            if (!this.checkPermissionsIntern(sender, perm)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnyPermissions(CommandSender sender, String[] permissions) {
        boolean hasPerm = this.hasAnyPermissionSilent(sender, permissions);
        if (!hasPerm) {
            sender.sendMessage(ChatColor.RED + "You don't have Permissions!");
        }
        return hasPerm;
    }

    public PermissionPlugin getHandle() {
        return this.permPlugin;
    }

    @Override
    public void addPermission(OfflinePlayer player, String permission) {
        this.permPlugin.addPermission(player, permission);
    }

    @Override
    public boolean isActive() {
        return this.permPlugin.isActive();
    }

    @Override
    public boolean getPermissions(CommandSender sender, String permissionNode) {
        return this.permPlugin.getPermissions(sender, permissionNode);
    }

    @Override
    public boolean getPermissions(String playerName, String permissionNode) {
        return this.permPlugin.getPermissions(playerName, permissionNode);
    }

    @Override
    public List<String> getGroups() {
        return this.permPlugin.getGroups();
    }

    @Override
    public void init() {
        this.permPlugin = this.checkForPermissionsPlugin(null);
    }

    @Override
    public String getName() {
        return this.permPlugin.getName();
    }

    @Override
    public void removePermission(OfflinePlayer player, String permission) {
        this.permPlugin.removePermission(player, permission);
    }

    @Override
    public boolean hasGroupSupport() {
        return this.permPlugin.hasGroupSupport();
    }

    @Override
    public void addGroup(OfflinePlayer player, String group) {
        if (!this.hasGroupSupport()) {
            return;
        }
        this.permPlugin.addGroup(player, group);
    }

    @Override
    public void removeGroup(OfflinePlayer player, String group) {
        if (!this.hasGroupSupport()) {
            return;
        }
        this.permPlugin.addGroup(player, group);
    }

    @Override
    public boolean hasSubgroupSupport() {
        return this.permPlugin.hasSubgroupSupport();
    }

    @Override
    public void addSubgroup(OfflinePlayer player, String subgroup) {
        if (!this.hasSubgroupSupport()) {
            return;
        }
        this.permPlugin.addSubgroup(player, subgroup);
    }

    @Override
    public List<String> listSubgroups(OfflinePlayer player) {
        if (!this.hasSubgroupSupport()) {
            return new LinkedList<String>();
        }
        return this.permPlugin.listSubgroups(player);
    }

    @Override
    public void removeSubgroup(OfflinePlayer player, String subgroup) {
        if (!this.hasSubgroupSupport()) {
            return;
        }
        this.permPlugin.removeSubgroup(player, subgroup);
    }
}

