/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.naming;

import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Method;
import java.util.Properties;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;

public class NativeMCTranslation {
    private static final String LANG_DIR_NAME = "lang";

    public static String getEntityTypeName(EntityType entityType, String language) {
        try {
            return entityType.getName();
        }
        catch (Throwable exp) {
            return entityType.name();
        }
    }

    public static String getItemTranslation(ItemStack item, String language) {
        try {
            char splitter = '.';
            Class<?> craftItemClass = Class.forName("org" + splitter + "bukkit" + splitter + "craftbukkit" + splitter + NativeMCTranslation.getCBReloc() + splitter + "inventory" + splitter + "CraftItemStack");
            Method method = craftItemClass.getMethod("asNMSCopy", ItemStack.class);
            Object nmsItemStack = method.invoke(null, item);
            Method getItem = nmsItemStack.getClass().getMethod("getItem", new Class[0]);
            Object nmsItem = getItem.invoke(nmsItemStack, new Object[0]);
            Method getName = nmsItem.getClass().getMethod("k", nmsItemStack.getClass());
            String itemName = (String)getName.invoke(nmsItem, nmsItemStack);
            return NativeMCTranslation.getTranslation(itemName + ".name", language);
        }
        catch (Throwable exp) {
            return item.getType().name();
        }
    }

    public static String getTranslation(String toTranslate) {
        try {
            char splitter = '.';
            Class<?> locali18n = Class.forName("net" + splitter + "minecraft" + splitter + "server" + splitter + NativeMCTranslation.getCBReloc() + splitter + "LocaleI18n");
            Method method = locali18n.getMethod("get", String.class);
            return (String)method.invoke(null, toTranslate);
        }
        catch (Throwable exp) {
            return toTranslate;
        }
    }

    public static String getTranslation(String toTranslate, String language) {
        try {
            File mcFile = new File(Server.class.getProtectionDomain().getCodeSource().getLocation().getPath());
            File currentDir = mcFile.getParentFile();
            currentDir = new File(currentDir.getAbsolutePath().replaceAll("%20", " "));
            File langDir = new File(currentDir, LANG_DIR_NAME);
            File langFile = new File(langDir, language + ".lang");
            if (!langFile.exists()) {
                return NativeMCTranslation.getTranslation(toTranslate);
            }
            Properties properties = new Properties();
            properties.load(new FileInputStream(langFile));
            if (properties.containsKey(toTranslate)) {
                return properties.getProperty(toTranslate);
            }
            return NativeMCTranslation.getTranslation(toTranslate);
        }
        catch (Throwable exp) {
            return NativeMCTranslation.getTranslation(toTranslate);
        }
    }

    private static String getCBReloc() {
        try {
            String bukkitPath = Bukkit.getServer().getClass().getPackage().getName();
            String[] split = bukkitPath.split("\\.");
            return split[split.length - 1];
        }
        catch (Throwable exp) {
            return "";
        }
    }
}

