/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.math;

public class Levenshtein {
    public static int levenshteinDistance(String s, String t) {
        int sIndex;
        int sLen = s.length();
        int tLen = t.length();
        if (sLen == 0) {
            return tLen;
        }
        if (tLen == 0) {
            return sLen;
        }
        int[] costsPrev = new int[sLen + 1];
        int[] costs = new int[sLen + 1];
        for (sIndex = 0; sIndex <= sLen; ++sIndex) {
            costsPrev[sIndex] = sIndex;
        }
        for (int tIndex = 1; tIndex <= tLen; ++tIndex) {
            char tIndexChar = t.charAt(tIndex - 1);
            costs[0] = tIndex;
            for (sIndex = 1; sIndex <= sLen; ++sIndex) {
                int cost = s.charAt(sIndex - 1) == tIndexChar ? 0 : 1;
                costs[sIndex] = Math.min(Math.min(costs[sIndex - 1] + 1, costsPrev[sIndex] + 1), costsPrev[sIndex - 1] + cost);
            }
            int[] tmpArr = costsPrev;
            costsPrev = costs;
            costs = tmpArr;
        }
        return costsPrev[sLen];
    }

    public static <T> T getNearest(String test, T[] objects) {
        T nearest = null;
        int best = 100000;
        for (T obj : objects) {
            int dist = Levenshtein.levenshteinDistance(test, obj.toString());
            if (dist >= best) continue;
            nearest = obj;
            best = dist;
        }
        return nearest;
    }

    public static <T> T getNearestIgnoreCase(String test, T[] objects) {
        test = test.toLowerCase();
        T nearest = null;
        int best = 100000;
        for (T obj : objects) {
            int dist = Levenshtein.levenshteinDistance(test, obj.toString().toLowerCase());
            if (dist >= best) continue;
            nearest = obj;
            best = dist;
        }
        return nearest;
    }
}

