/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.items;

import de.tobiyas.util.RaC.collections.CollectionUtils;
import de.tobiyas.util.RaC.formating.ParseUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemUtils {
    public static ItemQuality getItemValue(ItemStack stack) {
        switch (stack.getType()) {
            case LEATHER_HELMET: 
            case LEATHER_CHESTPLATE: 
            case LEATHER_LEGGINGS: 
            case LEATHER_BOOTS: {
                return ItemQuality.Leather;
            }
            case CHAINMAIL_HELMET: 
            case CHAINMAIL_CHESTPLATE: 
            case CHAINMAIL_LEGGINGS: 
            case CHAINMAIL_BOOTS: {
                return ItemQuality.Chain;
            }
            case IRON_HELMET: 
            case IRON_CHESTPLATE: 
            case IRON_LEGGINGS: 
            case IRON_BOOTS: {
                return ItemQuality.Iron;
            }
            case DIAMOND_HELMET: 
            case DIAMOND_CHESTPLATE: 
            case DIAMOND_LEGGINGS: 
            case DIAMOND_BOOTS: {
                return ItemQuality.Diamond;
            }
            case GOLD_HELMET: 
            case GOLD_CHESTPLATE: 
            case GOLD_LEGGINGS: 
            case GOLD_BOOTS: {
                return ItemQuality.Gold;
            }
        }
        return ItemQuality.None;
    }

    public static WeaponToolQuality getToolWeaponValue(Material mat) {
        switch (mat) {
            case WOOD_SPADE: 
            case WOOD_AXE: 
            case WOOD_HOE: 
            case WOOD_PICKAXE: 
            case WOOD_SWORD: {
                return WeaponToolQuality.Wood;
            }
            case STONE_SPADE: 
            case STONE_AXE: 
            case STONE_HOE: 
            case STONE_PICKAXE: 
            case STONE_SWORD: {
                return WeaponToolQuality.Stone;
            }
            case IRON_SPADE: 
            case IRON_AXE: 
            case IRON_HOE: 
            case IRON_PICKAXE: 
            case IRON_SWORD: {
                return WeaponToolQuality.Iron;
            }
            case GOLD_SPADE: 
            case GOLD_AXE: 
            case GOLD_HOE: 
            case GOLD_PICKAXE: 
            case GOLD_SWORD: {
                return WeaponToolQuality.Gold;
            }
            case DIAMOND_SPADE: 
            case DIAMOND_AXE: 
            case DIAMOND_HOE: 
            case DIAMOND_PICKAXE: 
            case DIAMOND_SWORD: {
                return WeaponToolQuality.Diamond;
            }
        }
        return WeaponToolQuality.None;
    }

    public static int getArmorValueOfItem(ItemStack stack) {
        if (stack == null || stack.getType() == Material.AIR) {
            return 0;
        }
        switch (stack.getType()) {
            case LEATHER_BOOTS: {
                return 1;
            }
            case LEATHER_HELMET: {
                return 1;
            }
            case LEATHER_LEGGINGS: {
                return 2;
            }
            case LEATHER_CHESTPLATE: {
                return 3;
            }
            case GOLD_BOOTS: {
                return 1;
            }
            case GOLD_HELMET: {
                return 2;
            }
            case GOLD_LEGGINGS: {
                return 3;
            }
            case GOLD_CHESTPLATE: {
                return 5;
            }
            case CHAINMAIL_BOOTS: {
                return 1;
            }
            case CHAINMAIL_HELMET: {
                return 2;
            }
            case CHAINMAIL_LEGGINGS: {
                return 4;
            }
            case CHAINMAIL_CHESTPLATE: {
                return 5;
            }
            case IRON_BOOTS: {
                return 2;
            }
            case IRON_HELMET: {
                return 2;
            }
            case IRON_LEGGINGS: {
                return 5;
            }
            case IRON_CHESTPLATE: {
                return 6;
            }
            case DIAMOND_BOOTS: {
                return 3;
            }
            case DIAMOND_HELMET: {
                return 3;
            }
            case DIAMOND_LEGGINGS: {
                return 6;
            }
            case DIAMOND_CHESTPLATE: {
                return 8;
            }
        }
        return 0;
    }

    public static ArmorSlot getItemSlotEquiping(ItemStack item) {
        if (item == null) {
            return ArmorSlot.NONE;
        }
        switch (item.getType()) {
            case LEATHER_HELMET: 
            case CHAINMAIL_HELMET: 
            case IRON_HELMET: 
            case DIAMOND_HELMET: 
            case GOLD_HELMET: {
                return ArmorSlot.HELMET;
            }
            case LEATHER_CHESTPLATE: 
            case CHAINMAIL_CHESTPLATE: 
            case IRON_CHESTPLATE: 
            case DIAMOND_CHESTPLATE: 
            case GOLD_CHESTPLATE: {
                return ArmorSlot.CHESTPLATE;
            }
            case LEATHER_LEGGINGS: 
            case CHAINMAIL_LEGGINGS: 
            case IRON_LEGGINGS: 
            case DIAMOND_LEGGINGS: 
            case GOLD_LEGGINGS: {
                return ArmorSlot.LEGGINGS;
            }
            case LEATHER_BOOTS: 
            case CHAINMAIL_BOOTS: 
            case IRON_BOOTS: 
            case DIAMOND_BOOTS: 
            case GOLD_BOOTS: {
                return ArmorSlot.BOOTS;
            }
        }
        return ArmorSlot.NONE;
    }

    public static ItemStack getItemInArmorSlotOfPlayer(Player player, ArmorSlot slot) {
        if (slot == null) {
            return null;
        }
        switch (slot) {
            case BOOTS: {
                return player.getInventory().getBoots();
            }
            case CHESTPLATE: {
                return player.getInventory().getChestplate();
            }
            case HELMET: {
                return player.getInventory().getHelmet();
            }
            case LEGGINGS: {
                return player.getInventory().getLeggings();
            }
            case NONE: {
                return null;
            }
        }
        return null;
    }

    public static ItemStack generateFromLine(String line) {
        return ItemUtils.generateFromLine(line, new ItemStack(Material.AIR));
    }

    public static ItemStack generateFromLine(String line, ItemStack defaultItem) {
        String[] split = line.split(Pattern.quote("#"));
        Material mat = null;
        short damage = 0;
        int amount = 1;
        String name = null;
        ArrayList<String> lore = new ArrayList<String>();
        HashMap<Enchantment, Integer> enchants = new HashMap<Enchantment, Integer>();
        boolean unbreakable = false;
        HashSet<ItemFlag> flags = new HashSet<ItemFlag>();
        if (split.length == 1) {
            mat = Material.matchMaterial((String)split[0]);
        }
        for (String part : split) {
            String[] partSplit;
            if (!part.contains(":") || (partSplit = part.split(Pattern.quote(":"), 2)).length != 2) continue;
            String key = partSplit[0];
            String value = partSplit[1];
            if (key.equalsIgnoreCase("material")) {
                mat = Material.matchMaterial((String)value.toUpperCase());
                continue;
            }
            if (key.equalsIgnoreCase("damage")) {
                damage = ParseUtils.parseShort(value, (short)0);
                continue;
            }
            if (key.equalsIgnoreCase("amount")) {
                amount = ParseUtils.parseInt(value, 1);
                continue;
            }
            if (key.equalsIgnoreCase("name")) {
                name = ChatColor.translateAlternateColorCodes((char)'&', (String)value);
                continue;
            }
            if (key.equalsIgnoreCase("lore")) {
                String[] loreSplit = value.split(Pattern.quote("~"));
                lore.addAll(Arrays.asList(loreSplit));
                CollectionUtils.translateChatColors(lore);
                continue;
            }
            if (key.equalsIgnoreCase("enchant")) {
                String[] enchantSplit;
                if (value.trim().equals("true")) {
                    enchants.put(Enchantment.DURABILITY, 1);
                    continue;
                }
                for (String enchantLine : enchantSplit = value.split(Pattern.quote("~"))) {
                    String[] enchantSplit2 = enchantLine.split(Pattern.quote(":"));
                    if (enchantSplit2.length != 2) continue;
                    Enchantment ench = Enchantment.getByName((String)enchantSplit2[0]);
                    int level = 1;
                    ParseUtils.parseInt(value, 1);
                    if (ench == null) continue;
                    enchants.put(ench, level);
                }
                continue;
            }
            if (key.equalsIgnoreCase("flags")) {
                String[] flagSplit;
                for (String flagPart : flagSplit = value.split("~")) {
                    try {
                        ItemFlag flag = ItemFlag.valueOf((String)flagPart.toUpperCase());
                        if (flag == null) continue;
                        flags.add(flag);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            if (!key.equalsIgnoreCase("unbreakable") || !(unbreakable = ParseUtils.parseBoolean(value.trim(), false))) continue;
            flags.add(ItemFlag.HIDE_UNBREAKABLE);
        }
        if (mat == null) {
            return defaultItem;
        }
        ItemStack item = new ItemStack(mat, amount, damage);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            if (name != null) {
                meta.setDisplayName(name);
            }
            if (!lore.isEmpty()) {
                meta.setLore(lore);
            }
            if (!flags.isEmpty()) {
                meta.addItemFlags(flags.toArray(new ItemFlag[flags.size()]));
            }
            try {
                Object spigot = meta.getClass().getMethod("spigot", new Class[0]).invoke((Object)meta, new Object[0]);
                spigot.getClass().getMethod("setUnbreakable", Boolean.TYPE).invoke(spigot, unbreakable);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (!enchants.isEmpty()) {
                for (Map.Entry entry : enchants.entrySet()) {
                    meta.addEnchant((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue(), true);
                }
            }
        }
        item.setItemMeta(meta);
        return item;
    }

    public static void setUnbreakable(ItemStack item, boolean unbreakable) {
        try {
            ItemMeta meta = item.getItemMeta();
            Method method = meta.getClass().getDeclaredMethod("spigot", new Class[0]);
            Object spigot = method.invoke((Object)meta, new Object[0]);
            Method method2 = spigot.getClass().getMethod("setUnbreakable", Boolean.TYPE);
            method2.invoke(spigot, unbreakable);
            item.setItemMeta(meta);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static enum ArmorSlot {
        HELMET,
        CHESTPLATE,
        LEGGINGS,
        BOOTS,
        NONE;

    }

    public static enum WeaponToolQuality {
        None(-1),
        Wood(0),
        Stone(1),
        Iron(2),
        Gold(3),
        Diamond(4);

        private int value;

        private WeaponToolQuality(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum ItemQuality {
        None(-1),
        Leather(0),
        Iron(1),
        Gold(2),
        Diamond(3),
        Chain(4);

        private int value;

        private ItemQuality(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

