/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.items;

import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemMetaUtils {
    public static void setDisplayNameOfItem(ItemStack item, String newDisplayName) {
        if (newDisplayName.length() > 46) {
            newDisplayName = newDisplayName.substring(0, 46);
        }
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(newDisplayName);
        item.setItemMeta(meta);
    }

    public static void addStringToLore(ItemStack item, String toAdd) {
        ItemMeta meta = item.getItemMeta();
        LinkedList<String> lore = null;
        lore = meta.hasLore() ? meta.getLore() : new LinkedList<String>();
        lore.addAll(ItemMetaUtils.formatToLore(toAdd));
        meta.setLore(lore);
        item.setItemMeta(meta);
    }

    public static void addUnformatedStringToLore(ItemStack item, String toAdd) {
        ItemMeta meta = item.getItemMeta();
        List lore = meta.hasLore() ? meta.getLore() : new LinkedList();
        lore.add(toAdd);
        meta.setLore(lore);
        item.setItemMeta(meta);
    }

    public static List<String> formatToLore(String unformated) {
        return ItemMetaUtils.formatToLore(unformated, 27);
    }

    public static List<String> formatToLore(String unformated, int maxLineLength) {
        String[] words = unformated.split(" ");
        LinkedList<String> lore = new LinkedList<String>();
        String currentLine = ChatColor.YELLOW + " -" + words[0];
        for (int i = 1; i < words.length; ++i) {
            String currentWord = words[i];
            if (ItemMetaUtils.getLengthWithoutColor(currentLine) + ItemMetaUtils.getLengthWithoutColor(currentWord) + 1 > maxLineLength) {
                lore.add(currentLine);
                currentLine = ChatColor.YELLOW + "  " + currentWord;
                continue;
            }
            currentLine = currentLine + " " + currentWord;
        }
        if (currentLine.length() > 0) {
            lore.add(currentLine);
        }
        return lore;
    }

    private static int getLengthWithoutColor(String text) {
        return ChatColor.stripColor((String)text).length();
    }

    public static void replaceLoreWith(ItemStack item, String newLore) {
        List<String> newLoreList = ItemMetaUtils.formatToLore(newLore);
        ItemMeta meta = item.getItemMeta();
        meta.setLore(newLoreList);
        item.setItemMeta(meta);
    }

    public static void removeLore(ItemStack item) {
        LinkedList emptyList = new LinkedList();
        ItemMeta meta = item.getItemMeta();
        meta.setLore(emptyList);
        item.setItemMeta(meta);
    }
}

