/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.items;

import java.util.Random;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;

public class ItemContainer {
    private Material itemMaterial;
    private int damageValue;
    private int minAmount;
    private int maxAmount;
    private double probability;
    private int randomEnchants;
    private Random rand;

    public ItemContainer(int itemID, int damageValue, int minAmount, int maxAmount, double probability) {
        this(itemID, damageValue, minAmount, maxAmount, probability, 0);
    }

    public ItemContainer(int itemID, int damageValue, int minAmount, int maxAmount, double probability, int randomEnchants) {
        this.itemMaterial = Material.getMaterial((int)itemID);
        this.damageValue = damageValue;
        this.minAmount = minAmount;
        this.maxAmount = maxAmount;
        this.probability = probability;
        this.randomEnchants = randomEnchants;
        this.rand = new Random();
    }

    public ItemStack generateItemStack() {
        int amount = this.generateAmount();
        if (amount == 0) {
            return null;
        }
        ItemStack item = this.generateItem(amount);
        return item;
    }

    private int generateAmount() {
        int rawAmount = this.minAmount;
        if (this.maxAmount != -1) {
            rawAmount = this.minAmount + this.rand.nextInt(this.maxAmount - this.minAmount + 1);
        }
        int realAmount = 0;
        for (int i = 0; i < rawAmount; ++i) {
            if (!(this.rand.nextDouble() * 100.0 <= this.probability)) continue;
            ++realAmount;
        }
        return realAmount;
    }

    private ItemStack generateItem(int amount) {
        ItemStack item = null;
        item = this.damageValue == -1 ? new ItemStack(this.itemMaterial, amount) : new ItemStack(this.itemMaterial, amount, (short)this.damageValue);
        if (this.randomEnchants != 0) {
            this.enchantItem(item);
        }
        return item;
    }

    private void enchantItem(ItemStack item) {
        Enchantment[] enchants = Enchantment.values();
        for (int i = 0; i < this.randomEnchants; ++i) {
            int randEnchant = this.rand.nextInt(enchants.length);
            Enchantment enchant = enchants[randEnchant];
            int maxLevel = enchant.getMaxLevel();
            int minLevel = enchant.getStartLevel();
            int range = maxLevel - minLevel;
            int realLevel = minLevel + this.rand.nextInt(range + 1);
            if (!enchant.canEnchantItem(item)) continue;
            item.addEnchantment(enchant, realLevel);
        }
    }
}

