/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.items;

import de.tobiyas.util.RaC.formating.ParseUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemCheckTemplate {
    private static final ItemCheckTemplate ALWAYS_TRUE_TEMPLATE = new ItemCheckTemplate(Material.AIR, 0, 0, "", null){

        @Override
        public boolean appliable(ItemStack item) {
            return true;
        }
    };
    private final Material type;
    private final short damage;
    private final int amount;
    private final String name;
    private final Collection<String> lore = new ArrayList<String>();

    private ItemCheckTemplate(Material type, int damage, int amount, String name, Collection<String> lore) {
        this(type, (short)damage, amount, name, lore);
    }

    private ItemCheckTemplate(Material type, short damage, int amount, String name, Collection<String> lore) {
        this.type = type;
        this.damage = damage;
        this.amount = amount;
        this.name = name;
        if (lore != null && !lore.isEmpty()) {
            for (String line : lore) {
                this.lore.add(ChatColor.stripColor((String)line).toLowerCase());
            }
        }
    }

    public boolean appliable(ItemStack item) {
        if (item == null) {
            return false;
        }
        if (item.getType() != this.type) {
            return false;
        }
        if (this.damage >= 0 && item.getDurability() != this.damage) {
            return false;
        }
        if (item.getAmount() < this.amount) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null && !this.name.isEmpty()) {
            return false;
        }
        if (!meta.hasDisplayName() && !this.name.isEmpty()) {
            return false;
        }
        if (!this.name.isEmpty() && !meta.getDisplayName().equals(this.name)) {
            return false;
        }
        if (!this.lore.isEmpty()) {
            ArrayList<String> left = new ArrayList<String>(this.lore);
            for (String line : meta.getLore()) {
                left.remove(ChatColor.stripColor((String)line).toLowerCase());
            }
            if (!left.isEmpty()) {
                return false;
            }
        }
        return true;
    }

    public static ItemCheckTemplate generate(String line) {
        if (line == null || line.isEmpty()) {
            return ALWAYS_TRUE_TEMPLATE;
        }
        String[] parts = line.split(Pattern.quote(";"));
        Material type = ParseUtils.parseMaterial(parts, 0, Material.AIR);
        short damage = ParseUtils.parseShort(parts, 1, (short)-1);
        int amount = ParseUtils.parseInt(parts, 2, 1);
        String name = ParseUtils.parseString(parts, 3, "");
        ArrayList<String> lore = new ArrayList<String>();
        return new ItemCheckTemplate(type, damage, amount, name, (Collection<String>)lore);
    }

    public static ItemCheckTemplate TRUE() {
        return ALWAYS_TRUE_TEMPLATE;
    }
}

