/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.items;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemBuilder {
    private Material mat = Material.STONE;
    private short damage = 0;
    private int amount = 1;
    private String name = null;
    private List<String> lore = null;
    private Map<Enchantment, Integer> enchants = new HashMap<Enchantment, Integer>();

    public void loadFromItem(ItemStack itemToChange) {
        if (itemToChange == null) {
            return;
        }
        this.mat = itemToChange.getType();
        this.damage = itemToChange.getDurability();
        this.amount = itemToChange.getAmount();
        if (itemToChange.hasItemMeta()) {
            ItemMeta meta = itemToChange.getItemMeta();
            if (meta.hasDisplayName()) {
                this.name = meta.getDisplayName();
            }
            if (meta.hasLore()) {
                this.lore = new ArrayList<String>(meta.getLore());
            }
            if (meta.hasEnchants()) {
                this.enchants.clear();
                this.enchants.putAll(meta.getEnchants());
            }
        }
    }

    public Material getMat() {
        return this.mat;
    }

    public ItemBuilder setMat(Material mat) {
        this.mat = mat;
        return this;
    }

    public short getDamage() {
        return this.damage;
    }

    public ItemBuilder setDamage(short damage) {
        this.damage = damage;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public ItemBuilder setName(String name) {
        if (name != null) {
            this.name = ChatColor.translateAlternateColorCodes((char)'&', (String)name);
        }
        return this;
    }

    public List<String> getLore() {
        return this.lore;
    }

    public ItemBuilder setAmount(int amount) {
        this.amount = amount;
        return this;
    }

    public ItemBuilder setLore(List<String> lore) {
        this.lore = this.translateChatColors(lore);
        return this;
    }

    public ItemBuilder setLore(String ... lore) {
        return this.setLore(Arrays.asList(lore));
    }

    public ItemBuilder setEnchants(List<String> enchantString) {
        for (String enchant : enchantString) {
            String[] split = enchant.split(Pattern.quote(":"));
            if (split.length != 2) continue;
            Enchantment en = Enchantment.getByName((String)split[0]);
            int level = 0;
            try {
                level = Integer.parseInt(split[1]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (level <= 0 || en == null) continue;
            this.enchants.put(en, level);
        }
        return this;
    }

    public ItemBuilder setEnchants(Map<Enchantment, Integer> enchants) {
        this.enchants.clear();
        this.enchants.putAll(enchants);
        return this;
    }

    public ItemStack build() {
        ItemStack item = new ItemStack(this.mat, this.amount, this.damage);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            if (this.name != null) {
                meta.setDisplayName(this.name);
            }
            if (this.lore != null && !this.lore.isEmpty()) {
                meta.setLore(this.lore);
            }
            if (!this.enchants.isEmpty()) {
                for (Map.Entry<Enchantment, Integer> entry : this.enchants.entrySet()) {
                    meta.addEnchant(entry.getKey(), entry.getValue().intValue(), true);
                }
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    private List<String> translateChatColors(List<String> list) {
        for (int i = 0; i < list.size(); ++i) {
            list.set(i, ChatColor.translateAlternateColorCodes((char)'&', (String)list.get(i)));
        }
        return list;
    }
}

