/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.items;

import java.util.Iterator;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.BrewEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class AbstractSpecificItem
implements Listener {
    protected Material itemWanted = this.getItemWanted();
    protected String itemTagWanted = this.getTagWanted();
    protected String itemNameWanted = this.getNameWanted();
    protected final JavaPlugin plugin;
    protected boolean consume = false;
    protected int consumeAmount = 1;
    protected boolean cancleCrafting = true;
    protected boolean cancleDropping = false;
    protected boolean cancleBrewing = false;

    public AbstractSpecificItem(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public AbstractSpecificItem register() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        return this;
    }

    protected abstract Material getItemWanted();

    protected abstract String getTagWanted();

    protected abstract String getNameWanted();

    @EventHandler
    public void cancleItemCraft(CraftItemEvent event) {
        if (!this.cancleCrafting) {
            return;
        }
        for (ItemStack item : event.getInventory().getContents()) {
            if (!this.isWantedItem(item)) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void removeDBItemOnDeath(PlayerDeathEvent event) {
        Iterator it = event.getDrops().iterator();
        while (it.hasNext()) {
            if (!this.isWantedItem((ItemStack)it.next())) continue;
            it.remove();
        }
    }

    @EventHandler
    public void cancleBrewing(BrewEvent event) {
        for (ItemStack item : event.getContents().getContents()) {
            if (!this.isWantedItem(item)) continue;
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void destroyOnDrop(PlayerDropItemEvent event) {
        if (this.isWantedItem(event.getItemDrop().getItemStack())) {
            event.getItemDrop().remove();
        }
    }

    private boolean isWantedItem(ItemStack item) {
        if (item == null || item.getType().equals((Object)Material.AIR)) {
            return false;
        }
        if (item.getType() != this.itemWanted) {
            return false;
        }
        if (!item.hasItemMeta()) {
            return false;
        }
        if (!item.getItemMeta().hasLore()) {
            return false;
        }
        if (item.getItemMeta().getLore().size() != 1) {
            return false;
        }
        if (!item.getItemMeta().getDisplayName().equals(this.itemNameWanted)) {
            return false;
        }
        return ((String)item.getItemMeta().getLore().get(0)).equals(this.itemTagWanted);
    }

    public abstract ItemStack getWantedItem();

    @EventHandler(priority=EventPriority.HIGHEST)
    public void playerInteract(PlayerInteractEvent event) {
        ItemStack item = event.getItem();
        if (!this.isWantedItem(item)) {
            return;
        }
        if (!this.consume || item.getAmount() < this.consumeAmount) {
            return;
        }
        if (this.trigger(event.getPlayer()) && this.consume) {
            item.setAmount(item.getAmount() - this.consumeAmount);
            PlayerInventory inv = event.getPlayer().getInventory();
            inv.setItem(inv.getHeldItemSlot(), item);
        }
    }

    protected abstract boolean trigger(Player var1);
}

