/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.inventorymenu.stats;

import de.tobiyas.util.RaC.inventorymenu.BasicSelectionInterface;
import de.tobiyas.util.RaC.inventorymenu.stats.AbstractStatSelectionInterface;
import java.util.LinkedList;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class StringSelectionInterface
extends AbstractStatSelectionInterface {
    protected final ItemStack stringValueSelector;
    protected String value;

    public StringSelectionInterface(Player player, BasicSelectionInterface parent, Map<String, Object> config, String key, JavaPlugin plugin) {
        super(player, parent, "Edit String by clicking the Item", config, key, plugin);
        String predifined = "";
        try {
            predifined = (String)config.get(key);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.value = predifined;
        this.stringValueSelector = this.generateItem(Material.BEDROCK, ChatColor.RED + "Click to Edit", ChatColor.LIGHT_PURPLE + "Value : " + String.valueOf(this.value));
        this.redraw();
    }

    private void redraw() {
        ItemMeta meta = this.stringValueSelector.getItemMeta();
        LinkedList<String> lore = new LinkedList<String>();
        lore.add(ChatColor.LIGHT_PURPLE + "Value: " + String.valueOf(this.value));
        meta.setLore(lore);
        this.stringValueSelector.setItemMeta(meta);
        this.selectionInventory.clear();
        this.selectionInventory.setItem(4, this.stringValueSelector);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void readFirstWordsOfPlayer(PlayerCommandPreprocessEvent event) {
        if (event.getPlayer() != this.player) {
            return;
        }
        String message = event.getMessage();
        this.value = message = message.substring(1, message.length());
        event.setCancelled(true);
        this.player.sendMessage(ChatColor.RED + "Saved your String: " + ChatColor.LIGHT_PURPLE + message + ChatColor.RED + ".");
        this.scheduleReopen();
    }

    private void scheduleReopen() {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                StringSelectionInterface.this.player.openInventory((InventoryView)StringSelectionInterface.this);
                StringSelectionInterface.this.redraw();
            }
        }, 1L);
    }

    @Override
    protected Object unparseValue() {
        return this.value;
    }

    @Override
    protected void onSelectionItemPressed(ItemStack item) {
        if (this.stringValueSelector.equals((Object)item)) {
            this.isOpeningNewInv = true;
            this.closeAndReturnToParent();
            this.player.sendMessage(ChatColor.RED + "Enter a new String. Use " + ChatColor.LIGHT_PURPLE + "/<anyString>" + ChatColor.RED);
        }
    }

    @Override
    protected void onControlItemPressed(ItemStack item) {
    }
}

