/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.inventorymenu.stats;

import de.tobiyas.util.RaC.inventorymenu.BasicSelectionInterface;
import de.tobiyas.util.RaC.inventorymenu.stats.AbstractStatSelectionInterface;
import de.tobiyas.util.RaC.inventorymenu.stats.Operators;
import java.util.LinkedList;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;

public class OperatorSelectionInterface
extends AbstractStatSelectionInterface {
    protected ItemStack plusIndicator;
    protected ItemStack minusIndicator;
    protected ItemStack multIndicator;
    protected ItemStack currentOperationIndicator;
    protected Operators currentOperator;

    public OperatorSelectionInterface(Player player, BasicSelectionInterface parent, Map<String, Object> config, String key, JavaPlugin plugin) {
        super(player, parent, "Select a Operation (+,-,*)", config, key, plugin);
        this.generateIndicators();
    }

    protected void generateIndicators() {
        this.plusIndicator = this.generateItem(Material.WOOL, Operators.PLUS.getWoolColor(), ChatColor.GREEN + "PLUS", new LinkedList<String>());
        this.minusIndicator = this.generateItem(Material.WOOL, Operators.MINUS.getWoolColor(), ChatColor.RED + "MINUS", new LinkedList<String>());
        this.multIndicator = this.generateItem(Material.WOOL, Operators.MULT.getWoolColor(), ChatColor.YELLOW + "MULT", new LinkedList<String>());
        this.currentOperator = Operators.MULT;
        this.currentOperationIndicator = this.generateItem(Material.WOOL, Operators.MULT.getWoolColor(), ChatColor.GREEN + "PLUS", new LinkedList<String>());
        this.selectionInventory.setItem(3, this.plusIndicator);
        this.selectionInventory.setItem(4, this.minusIndicator);
        this.selectionInventory.setItem(5, this.multIndicator);
        this.controlInventory.setItem(4, this.currentOperationIndicator);
    }

    @Override
    protected boolean onBackPressed() {
        return true;
    }

    @Override
    protected void onSelectionItemPressed(ItemStack item) {
        if (this.plusIndicator.equals((Object)item)) {
            this.changeOperator(Operators.PLUS);
            return;
        }
        if (this.minusIndicator.equals((Object)item)) {
            this.changeOperator(Operators.MINUS);
            return;
        }
        if (this.multIndicator.equals((Object)item)) {
            this.changeOperator(Operators.MULT);
            return;
        }
    }

    private void changeOperator(Operators newOperator) {
        if (this.currentOperator == newOperator) {
            return;
        }
        this.currentOperator = newOperator;
        this.controlInventory.setItem(4, null);
        this.currentOperationIndicator.setDurability(this.currentOperator.getWoolColor());
        this.controlInventory.setItem(4, this.currentOperationIndicator);
    }

    @Override
    protected void onControlItemPressed(ItemStack item) {
        if (this.currentOperationIndicator.equals((Object)item)) {
            return;
        }
    }

    @Override
    protected Object unparseValue() {
        return Character.valueOf(this.currentOperator.getCharValue());
    }
}

