/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.inventorymenu.stats;

import de.tobiyas.util.RaC.inventorymenu.BasicSelectionInterface;
import de.tobiyas.util.RaC.inventorymenu.elements.ScrollableItems;
import de.tobiyas.util.RaC.inventorymenu.stats.AbstractStatSelectionInterface;
import java.util.LinkedList;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;

public class MaterialSelectionInterface
extends AbstractStatSelectionInterface {
    protected ScrollableItems itemScrollView = new ScrollableItems(this.selectionInventory, 0, 8, 0);
    protected ItemStack indicatorItem;
    protected Material selection = Material.ARROW;

    public MaterialSelectionInterface(Player player, BasicSelectionInterface parent, Map<String, Object> config, String key, JavaPlugin plugin) {
        super(player, parent, "Select a Material", config, key, plugin);
        if (config.containsKey(key)) {
            this.selection = (Material)config.get(key);
        }
        this.redraw();
    }

    protected void redraw() {
        this.itemScrollView.clear();
        for (Material mat : Material.values()) {
            ItemStack item = new ItemStack(mat);
            if (!this.filter(item)) continue;
            this.itemScrollView.addItem(item);
        }
        this.redrawIndicatorItem();
    }

    private void redrawIndicatorItem() {
        this.indicatorItem = this.generateItem(this.selection, ChatColor.AQUA + "Current Material", new LinkedList<String>());
        this.controlInventory.setItem(4, this.indicatorItem);
    }

    protected boolean filter(ItemStack item) {
        return true;
    }

    @Override
    protected Object unparseValue() {
        return this.selection;
    }

    @Override
    protected void onSelectionItemPressed(ItemStack item) {
        if (this.itemScrollView.checkScrollButtons(item)) {
            return;
        }
        for (ItemStack ownItem : this.itemScrollView.getAllItems()) {
            if (!item.equals((Object)ownItem)) continue;
            this.selection = item.getType();
            this.redrawIndicatorItem();
            return;
        }
    }

    @Override
    protected void onControlItemPressed(ItemStack item) {
        if (this.indicatorItem.equals((Object)item)) {
            return;
        }
    }
}

