/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.inventorymenu.stats;

import de.tobiyas.util.RaC.inventorymenu.BasicSelectionInterface;
import de.tobiyas.util.RaC.inventorymenu.stats.AbstractStatSelectionInterface;
import de.tobiyas.util.RaC.inventorymenu.stats.ArmorMaterialSelectionInterface;
import de.tobiyas.util.RaC.inventorymenu.stats.BlockMaterialSelectionInterface;
import de.tobiyas.util.RaC.inventorymenu.stats.IntegerSelectionInterface;
import de.tobiyas.util.RaC.inventorymenu.stats.ItemEnchantmentSelectionInterface;
import de.tobiyas.util.RaC.inventorymenu.stats.MaterialSelectionInterface;
import de.tobiyas.util.RaC.inventorymenu.stats.MaterialType;
import de.tobiyas.util.RaC.inventorymenu.stats.StringSelectionInterface;
import de.tobiyas.util.RaC.inventorymenu.stats.ToolMaterialSelectionInterface;
import de.tobiyas.util.RaC.inventorymenu.stats.WeaponMaterialSelectionInterface;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.java.JavaPlugin;

public class ItemSelectionInterface
extends AbstractStatSelectionInterface {
    private final String itemMaterialKey = "itemMaterial";
    private final String itemNameKey = "itemName";
    private final String itemDamagevalueKey = "itemDamagevalue";
    private final String itemAddEnchantmentKey = "itemEnchantment";
    private final String itemPlayerHeadKey = "itemPlayerHead";
    private Map<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
    private ItemStack addEnchantmentItem;
    private ItemStack materialSelectionItem;
    private Material mat;
    private ItemStack itemNameItem;
    private String itemName = "";
    private ItemStack damageValueItem;
    private short damageValue = 0;
    private ItemStack playerHeadItem;
    private String playerHeadName;
    private String currentKey = "";
    private ItemStack indicatorItem;
    private final MaterialType matType;

    public ItemSelectionInterface(Player player, BasicSelectionInterface parent, Map<String, Object> config, String key, JavaPlugin plugin, MaterialType matType) {
        super(player, parent, "Build your Item", config, key, plugin);
        ItemStack item;
        this.matType = matType;
        this.mat = Material.WOOL;
        this.damageValue = 0;
        this.itemName = "";
        this.playerHeadName = "";
        if (config.containsKey(key) && (item = (ItemStack)config.get(key)) != null) {
            SkullMeta meta;
            this.mat = item.getType();
            this.damageValue = item.getDurability();
            this.itemName = item.getItemMeta().getDisplayName();
            this.enchantments = new HashMap<Enchantment, Integer>(item.getEnchantments());
            if (item.getItemMeta() instanceof SkullMeta && (meta = (SkullMeta)item.getItemMeta()).hasOwner()) {
                this.playerHeadName = meta.getOwner();
            }
        }
        this.redraw();
    }

    protected void redraw() {
        this.materialSelectionItem = this.generateItem(this.mat, "Select Material", "Changes the Material.");
        this.selectionInventory.setItem(3, this.materialSelectionItem);
        this.itemNameItem = this.generateItem(Material.ANVIL, ChatColor.LIGHT_PURPLE + "Select ItemName", "Changes the ItemName.");
        this.selectionInventory.setItem(4, this.itemNameItem);
        this.damageValueItem = this.generateItem(Material.APPLE, ChatColor.AQUA + "Damage Value", new LinkedList<String>());
        this.selectionInventory.setItem(5, this.damageValueItem);
        this.addEnchantmentItem = this.generateItem(Material.PAPER, "Add Enchantment", new LinkedList<String>());
        this.selectionInventory.setItem(6, this.addEnchantmentItem);
        this.indicatorItem = this.generateItem(this.mat, this.damageValue, this.itemName, new LinkedList<String>());
        this.indicatorItem.addUnsafeEnchantments(this.enchantments);
        this.controlInventory.setItem(4, this.indicatorItem);
        this.playerHeadItem = this.generateItem(Material.SKULL_ITEM, "PlayerHead", "Head of: " + this.playerHeadName);
        this.selectionInventory.setItem(7, "".equals(this.playerHeadName) ? new ItemStack(Material.AIR) : this.playerHeadItem);
    }

    @Override
    protected Object unparseValue() {
        ItemStack item = new ItemStack(this.mat);
        item.addUnsafeEnchantments(this.enchantments);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(this.itemName);
        item.setItemMeta(meta);
        item.setDurability(this.damageValue);
        return item;
    }

    @Override
    protected void onSelectionItemPressed(ItemStack item) {
        if (item.equals((Object)this.materialSelectionItem)) {
            this.currentKey = "itemMaterial";
            this.config.put(this.currentKey, this.mat);
            MaterialSelectionInterface toOpen = null;
            switch (this.matType) {
                case ALL: {
                    toOpen = new MaterialSelectionInterface(this.player, (BasicSelectionInterface)this, this.config, this.currentKey, this.plugin);
                    break;
                }
                case ARMOR: {
                    toOpen = new ArmorMaterialSelectionInterface(this.player, (BasicSelectionInterface)this, this.config, this.currentKey, this.plugin);
                    break;
                }
                case BLOCK: {
                    toOpen = new BlockMaterialSelectionInterface(this.player, (BasicSelectionInterface)this, this.config, this.currentKey, this.plugin);
                    break;
                }
                case TOOLS: {
                    toOpen = new ToolMaterialSelectionInterface(this.player, (BasicSelectionInterface)this, this.config, this.currentKey, this.plugin);
                    break;
                }
                case WEAPONS: {
                    toOpen = new WeaponMaterialSelectionInterface(this.player, (BasicSelectionInterface)this, this.config, this.currentKey, this.plugin);
                    break;
                }
                default: {
                    toOpen = new MaterialSelectionInterface(this.player, (BasicSelectionInterface)this, this.config, this.currentKey, this.plugin);
                }
            }
            this.openNewView(toOpen);
            return;
        }
        if (item.equals((Object)this.itemNameItem)) {
            this.currentKey = "itemName";
            this.config.put(this.currentKey, this.itemName);
            this.openNewView(new StringSelectionInterface(this.player, (BasicSelectionInterface)this, this.config, this.currentKey, this.plugin));
            return;
        }
        if (item.equals((Object)this.damageValueItem)) {
            this.currentKey = "itemDamagevalue";
            this.config.put(this.currentKey, Integer.valueOf(this.damageValue));
            this.openNewView(new IntegerSelectionInterface(this.player, (BasicSelectionInterface)this, this.config, this.currentKey, this.plugin));
            return;
        }
        if (item.equals((Object)this.playerHeadItem)) {
            this.currentKey = "itemPlayerHead";
            this.config.put(this.currentKey, this.playerHeadName);
            this.openNewView(new StringSelectionInterface(this.player, (BasicSelectionInterface)this, this.config, this.currentKey, this.plugin));
        }
        if (item.equals((Object)this.addEnchantmentItem)) {
            this.currentKey = "itemEnchantment";
            this.openNewView(new ItemEnchantmentSelectionInterface(this.player, (BasicSelectionInterface)this, this.config, this.currentKey, this.plugin));
        }
    }

    @Override
    protected void onControlItemPressed(ItemStack item) {
        if (item.equals((Object)this.indicatorItem)) {
            return;
        }
    }

    @Override
    protected void notifyReopened() {
        super.notifyReopened();
        Object newValue = this.config.get(this.currentKey);
        if (newValue == null) {
            return;
        }
        if (this.currentKey.equalsIgnoreCase("itemMaterial")) {
            this.mat = (Material)newValue;
            this.redraw();
            return;
        }
        if (this.currentKey.equalsIgnoreCase("itemName")) {
            this.itemName = ChatColor.translateAlternateColorCodes((char)'&', (String)((String)newValue));
            this.redraw();
            return;
        }
        if (this.currentKey.equalsIgnoreCase("itemDamagevalue")) {
            int newDamageValue = (Integer)newValue;
            this.damageValue = (short)newDamageValue;
            this.redraw();
            return;
        }
        if (this.currentKey.equalsIgnoreCase("itemEnchantment")) {
            ItemEnchantmentSelectionInterface.EnchantmentContainer container = (ItemEnchantmentSelectionInterface.EnchantmentContainer)newValue;
            if (container != null) {
                this.enchantments.put(container.enchantment, container.level);
                this.redraw();
            }
            return;
        }
        if (this.currentKey.equalsIgnoreCase("itemPlayerHead")) {
            String newPlayerHeadName;
            this.playerHeadName = newPlayerHeadName = (String)newValue;
            this.redraw();
        }
    }
}

