/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.inventorymenu.stats;

import de.tobiyas.util.RaC.inventorymenu.BasicSelectionInterface;
import de.tobiyas.util.RaC.inventorymenu.elements.ScrollableItems;
import de.tobiyas.util.RaC.inventorymenu.stats.AbstractStatSelectionInterface;
import de.tobiyas.util.RaC.inventorymenu.stats.IntegerSelectionInterface;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;

public class ItemEnchantmentSelectionInterface
extends AbstractStatSelectionInterface {
    private final ScrollableItems enchantmentScrollView;
    private final Map<ItemStack, Enchantment> enchantmentItemMap = new HashMap<ItemStack, Enchantment>();
    private ItemStack enchantmentItem;
    private Enchantment enchantment;
    private String currentKey = "";
    private ItemStack levelItem;
    private int level = 1;
    private final String LEVEL_KEY = "level";

    public ItemEnchantmentSelectionInterface(Player player, BasicSelectionInterface parent, Map<String, Object> config, String key, JavaPlugin plugin) {
        super(player, parent, "Add Enchant", config, key, plugin);
        this.enchantmentScrollView = new ScrollableItems(this.selectionInventory, 0, 8, 0);
        this.redraw();
    }

    private void redraw() {
        this.enchantmentScrollView.clear();
        this.enchantmentItemMap.clear();
        for (Enchantment enchantment : Enchantment.values()) {
            ItemStack item = this.generateItem(Material.PAPER, enchantment.getName(), new LinkedList<String>());
            item.addUnsafeEnchantment(enchantment, 1);
            this.enchantmentScrollView.addItem(item);
            this.enchantmentItemMap.put(item, enchantment);
        }
        this.enchantmentItem = this.generateItem(Material.PAPER, "The selected Enchantment", new LinkedList<String>());
        if (this.enchantment != null) {
            this.enchantmentItem.addUnsafeEnchantment(this.enchantment, this.level);
        }
        this.levelItem = this.generateItem(Material.ARROW, "Level: " + this.level, "The Level of the Enchant");
        this.controlInventory.setItem(4, this.enchantmentItem);
        this.controlInventory.setItem(3, this.levelItem);
    }

    @Override
    protected Object unparseValue() {
        EnchantmentContainer container = new EnchantmentContainer();
        container.enchantment = this.enchantment;
        container.level = this.level;
        return container;
    }

    @Override
    protected void onSelectionItemPressed(ItemStack item) {
        if (this.enchantmentScrollView.checkScrollButtons(item)) {
            return;
        }
        for (Map.Entry<ItemStack, Enchantment> entry : this.enchantmentItemMap.entrySet()) {
            ItemStack entryItem = entry.getKey();
            Enchantment enchantment = entry.getValue();
            if (!entryItem.equals((Object)item)) continue;
            this.enchantment = enchantment;
            this.redraw();
            return;
        }
    }

    @Override
    protected void onControlItemPressed(ItemStack item) {
        if (item.equals((Object)this.levelItem)) {
            this.currentKey = "level";
            this.config.put(this.currentKey, this.level);
            this.openNewView(new IntegerSelectionInterface(this.player, (BasicSelectionInterface)this, this.config, this.currentKey, this.plugin));
            return;
        }
    }

    @Override
    protected void notifyReopened() {
        super.notifyReopened();
        if (this.currentKey.equals("level") && this.config.containsKey(this.currentKey)) {
            int newLevel = (Integer)this.config.get(this.currentKey);
            if (this.level > 0) {
                this.level = newLevel;
                this.redraw();
            }
            return;
        }
    }

    public class EnchantmentContainer {
        public Enchantment enchantment;
        public int level;
    }
}

