/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.inventorymenu.stats;

import de.tobiyas.util.RaC.inventorymenu.BasicSelectionInterface;
import de.tobiyas.util.RaC.inventorymenu.elements.ItemScrollView;
import de.tobiyas.util.RaC.inventorymenu.stats.AbstractStatSelectionInterface;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;

public class IntegerSelectionInterface
extends AbstractStatSelectionInterface {
    protected ItemScrollView indicator1;
    protected ItemScrollView indicator10;
    protected ItemScrollView indicator100;
    protected ItemScrollView indicator1000;
    protected ItemScrollView indicator10000;
    protected double value = 0.0;

    public IntegerSelectionInterface(Player player, BasicSelectionInterface parent, Map<String, Object> config, String key, JavaPlugin plugin) {
        this(player, parent, "Select an Integer", config, key, plugin);
    }

    public IntegerSelectionInterface(Player player, BasicSelectionInterface parent, String selectName, Map<String, Object> config, String key, JavaPlugin plugin) {
        super(player, parent, selectName, config, key, plugin);
        if (config.containsKey(key) && config.get(key) instanceof Double) {
            this.value = (Double)config.get(key);
        }
        this.generateIndicators();
        this.totalRedraw();
    }

    protected void generateIndicators() {
        this.indicator1 = new ItemScrollView("1s", 4, this.selectionInventory);
        this.indicator10 = new ItemScrollView("10s", 3, this.selectionInventory);
        this.indicator100 = new ItemScrollView("100s", 2, this.selectionInventory);
        this.indicator1000 = new ItemScrollView("1000s", 1, this.selectionInventory);
        this.indicator10000 = new ItemScrollView("10000s", 0, this.selectionInventory);
    }

    protected void totalRedraw() {
        this.indicator1.redrawInventory();
        this.indicator10.redrawInventory();
        this.indicator100.redrawInventory();
        this.indicator1000.redrawInventory();
        this.indicator10000.redrawInventory();
    }

    @Override
    protected void onSelectionItemPressed(ItemStack item) {
        if (this.checkAnyReaction(item)) {
            this.rescanValue();
        }
    }

    protected boolean checkAnyReaction(ItemStack item) {
        if (this.indicator1.react(item)) {
            return true;
        }
        if (this.indicator10.react(item)) {
            return true;
        }
        if (this.indicator100.react(item)) {
            return true;
        }
        if (this.indicator1000.react(item)) {
            return true;
        }
        return this.indicator10000.react(item);
    }

    @Override
    protected void onControlItemPressed(ItemStack item) {
    }

    protected void rescanValue() {
        int tempValue = 0;
        tempValue += 1 * this.indicator1.getCurrentValue();
        tempValue += 10 * this.indicator10.getCurrentValue();
        tempValue += 100 * this.indicator100.getCurrentValue();
        tempValue += 1000 * this.indicator1000.getCurrentValue();
        this.value = tempValue += 10000 * this.indicator10000.getCurrentValue();
    }

    protected void setValue(double value) {
        this.value = value;
        int value_1s = this.getDigit(value, 1);
        int value_10s = this.getDigit(value, 2);
        int value_100s = this.getDigit(value, 3);
        int value_1000s = this.getDigit(value, 4);
        int value_10000s = this.getDigit(value, 5);
        this.indicator1.setCurrentValue(value_1s);
        this.indicator10.setCurrentValue(value_10s);
        this.indicator100.setCurrentValue(value_100s);
        this.indicator1000.setCurrentValue(value_1000s);
        this.indicator10000.setCurrentValue(value_10000s);
    }

    protected int getDigit(double value, int digit) {
        return (int)(value / Math.pow(10.0, digit - 1) % 10.0);
    }

    @Override
    protected Object unparseValue() {
        return (int)this.value;
    }
}

