/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.inventorymenu.elements;

import de.tobiyas.util.RaC.inventorymenu.elements.ItemSorter;
import de.tobiyas.util.RaC.vollotile.VollotileCode;
import de.tobiyas.util.RaC.vollotile.VollotileCodeManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class ScrollableItems {
    private ItemStack upButton;
    private ItemStack downButton;
    private final Inventory inventory;
    private final int fromColumn;
    private final int toColumn;
    private final List<ItemStack> itemsToScroll;
    private final List<ItemStack> visibleItems;
    private int currentRow = 0;
    private final int fromRow;
    private boolean sortForNames = false;

    public ScrollableItems(Inventory inventory) {
        this(inventory, 0, 8, 0);
    }

    public ScrollableItems(Inventory inventory, int fromColumn, int toColumn, int fromRow) {
        this.inventory = inventory;
        this.fromColumn = fromColumn;
        this.toColumn = toColumn;
        this.fromRow = fromRow;
        this.visibleItems = new LinkedList<ItemStack>();
        this.itemsToScroll = new LinkedList<ItemStack>();
        this.upButton = this.generateUpItem();
        this.downButton = this.generateDownItem();
        this.redrawCurrent();
    }

    private ItemStack generateDownItem() {
        if (this.hasInventoryHeadSupport()) {
            return this.generateHead("MHF_ArrowDown", ChatColor.RED + "Scroll Down", "Scrolls the List down.");
        }
        ItemStack item = new ItemStack(Material.BLAZE_ROD);
        ItemMeta meta = this.downButton.getItemMeta();
        LinkedList<String> lore = new LinkedList<String>();
        lore.add("LESS");
        meta.setLore(lore);
        meta.setDisplayName(ChatColor.RED + "Scroll Down");
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack generateHead(String playerHeadName, String displayname, String ... lore) {
        ItemStack head = new ItemStack(Material.SKULL_ITEM);
        head.setDurability((short)3);
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        meta.setOwner(playerHeadName);
        meta.setLore(Arrays.asList(lore));
        meta.setDisplayName(displayname);
        head.setItemMeta((ItemMeta)meta);
        return head;
    }

    private ItemStack generateUpItem() {
        if (this.hasInventoryHeadSupport()) {
            return this.generateHead("MHF_ArrowUp", ChatColor.RED + "Scroll Up", "Scrolls the List down.");
        }
        ItemStack item = new ItemStack(Material.ARROW);
        ItemMeta meta = item.getItemMeta();
        LinkedList<String> lore = new LinkedList<String>();
        lore.add("MORE");
        meta.setLore(lore);
        meta.setDisplayName(ChatColor.GREEN + "Scroll Up");
        item.setItemMeta(meta);
        return item;
    }

    private boolean hasInventoryHeadSupport() {
        return VollotileCodeManager.getVollotileCode().getVersion().isVersionGreaterOrEqual(VollotileCode.MCVersion.v1_8_R1);
    }

    public void setUpButton(ItemStack item) {
        this.upButton = item.clone();
        this.upButton.setAmount(1);
        this.redrawCurrent();
    }

    public void setDownButton(ItemStack item) {
        this.upButton = item.clone();
        this.upButton.setAmount(1);
        this.redrawCurrent();
    }

    private void redrawCurrent() {
        if (this.sortForNames) {
            this.sortItems();
        }
        int height = this.inventory.getSize() / 9;
        int width = this.toColumn - this.fromColumn + 1 - 1;
        if (width <= 1) {
            return;
        }
        int totalRows = (int)Math.ceil((double)this.itemsToScroll.size() / (double)width);
        boolean showUpButton = this.currentRow != 0;
        boolean showDownButton = totalRows > this.currentRow + height;
        int startIndex = this.currentRow * 9 + this.fromColumn - 1;
        if (startIndex < 0) {
            startIndex = 0;
        }
        this.visibleItems.clear();
        int index = width * this.currentRow;
        for (int i_height = this.fromRow; i_height < height; ++i_height) {
            for (int i_width = this.fromColumn; i_width < width; ++i_width) {
                this.inventory.setItem(i_height * 9 + i_width, null);
                if (index >= this.itemsToScroll.size()) continue;
                ItemStack item = this.itemsToScroll.get(index);
                this.inventory.setItem(i_height * 9 + i_width, item);
                this.visibleItems.add(item);
                ++index;
            }
        }
        this.inventory.setItem(9 * this.fromRow + this.toColumn, null);
        this.inventory.setItem(9 * (this.fromRow + 2) + this.toColumn, null);
        if (showUpButton) {
            this.upButton.setAmount(this.currentRow);
            this.inventory.setItem(9 * this.fromRow + this.toColumn, this.upButton);
        }
        if (showDownButton) {
            int amount = totalRows - this.currentRow - height;
            if (amount <= 0) {
                amount = 1;
            }
            this.downButton.setAmount(amount);
            this.inventory.setItem(9 * (this.fromRow + 2) + this.toColumn, this.downButton);
        }
    }

    private void sortItems() {
        HashMap<String, ItemStack> assoc = new HashMap<String, ItemStack>();
        LinkedList<String> list = new LinkedList<String>();
        for (ItemStack item : this.itemsToScroll) {
            String name = item.getType().name();
            if (item.getItemMeta().hasDisplayName()) {
                name = ChatColor.stripColor((String)item.getItemMeta().getDisplayName());
            }
            list.add(name);
            assoc.put(name, item);
        }
        Collections.sort(list);
        int i = 0;
        for (String name : list) {
            ItemStack item = (ItemStack)assoc.get(name);
            this.itemsToScroll.set(i, item);
            ++i;
        }
    }

    public void addItem(ItemStack item) {
        this.itemsToScroll.add(item);
        this.redrawCurrent();
    }

    public void addItems(Collection<ItemStack> items) {
        this.itemsToScroll.addAll(items);
        this.redrawCurrent();
    }

    public void removeItem(ItemStack item) {
        this.itemsToScroll.remove(item);
        this.redrawCurrent();
    }

    public List<ItemStack> getAllItems() {
        return this.itemsToScroll;
    }

    public boolean checkScrollButtons(ItemStack item) {
        if (this.upButton.equals((Object)item)) {
            this.scrollUp();
            return true;
        }
        if (this.downButton.equals((Object)item)) {
            this.scrollDown();
            return true;
        }
        return false;
    }

    public void scrollDown() {
        int width = this.toColumn - this.fromColumn + 1 - 1;
        int totalRows = (int)Math.ceil((double)this.itemsToScroll.size() / (double)width);
        int height = this.inventory.getSize() / 9;
        ++this.currentRow;
        if (this.currentRow + height > totalRows) {
            --this.currentRow;
        }
        this.redrawCurrent();
    }

    public void scrollUp() {
        --this.currentRow;
        if (this.currentRow < 0) {
            this.currentRow = 0;
        }
        this.redrawCurrent();
    }

    public void clear() {
        this.currentRow = 0;
        this.itemsToScroll.clear();
        this.visibleItems.clear();
        this.redrawCurrent();
    }

    public boolean isSortForNames() {
        return this.sortForNames;
    }

    public void setSortForNames(boolean sortForNames) {
        this.sortForNames = sortForNames;
        this.redrawCurrent();
    }

    public void redraw() {
        this.redrawCurrent();
    }

    public void sortBySorter(ItemSorter sorter) {
        List<ItemStack> sorted = sorter.sortItems(this.itemsToScroll);
        this.itemsToScroll.clear();
        this.itemsToScroll.addAll(sorted);
        this.redraw();
    }

    public void sortByNameNow() {
        this.sortItems();
    }
}

