/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.inventorymenu.elements;

import de.tobiyas.util.RaC.vollotile.VollotileCode;
import de.tobiyas.util.RaC.vollotile.VollotileCodeManager;
import java.util.Arrays;
import java.util.LinkedList;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class ItemScrollView {
    private ItemStack upButton;
    private ItemStack indicator;
    private ItemStack downButton;
    private String name;
    private int value;
    private int column = -1;
    private final Inventory inventory;

    public ItemScrollView(String name, int column, Inventory inventory) {
        this.name = name;
        this.column = column;
        this.inventory = inventory;
        this.upButton = this.generateUpItem();
        this.indicator = this.generateIndicatorItem();
        this.downButton = this.generateDownItem();
    }

    private boolean hasInventoryHeadSupport() {
        return VollotileCodeManager.getVollotileCode().getVersion().isVersionGreaterOrEqual(VollotileCode.MCVersion.v1_8_R1);
    }

    private ItemStack generateDownItem() {
        if (this.hasInventoryHeadSupport()) {
            return this.generateHead("MHF_ArrowDown", ChatColor.RED + "Scroll Down " + this.name, "Scrolls the List down.");
        }
        ItemStack item = new ItemStack(Material.BLAZE_ROD);
        ItemMeta meta = this.downButton.getItemMeta();
        LinkedList<String> lore = new LinkedList<String>();
        lore.add("LESS");
        meta.setLore(lore);
        meta.setDisplayName(ChatColor.RED + "LESS" + this.name);
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack generateHead(String playerHeadName, String displayname, String ... lore) {
        ItemStack head = new ItemStack(Material.SKULL_ITEM);
        head.setDurability((short)3);
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        meta.setOwner(playerHeadName);
        meta.setLore(Arrays.asList(lore));
        meta.setDisplayName(displayname);
        head.setItemMeta((ItemMeta)meta);
        return head;
    }

    private ItemStack generateIndicatorItem() {
        ItemStack item = new ItemStack(Material.PAPER);
        ItemMeta meta = this.indicator.getItemMeta();
        LinkedList<String> lore = new LinkedList<String>();
        lore.add(ChatColor.LIGHT_PURPLE + "VALUE" + this.name);
        meta.setLore(lore);
        meta.setDisplayName(this.name + " : " + this.value);
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack generateUpItem() {
        if (this.hasInventoryHeadSupport()) {
            return this.generateHead("MHF_ArrowUp", ChatColor.RED + "Scroll Up " + this.name, "Scrolls the List down.");
        }
        ItemStack item = new ItemStack(Material.ARROW);
        ItemMeta meta = this.upButton.getItemMeta();
        LinkedList<String> lore = new LinkedList<String>();
        lore.add("MORE");
        meta.setLore(lore);
        meta.setDisplayName(ChatColor.GREEN + "More " + this.name);
        item.setItemMeta(meta);
        return item;
    }

    public void redrawInventory() {
        this.inventory.setItem(this.column, null);
        this.inventory.setItem(9 + this.column, null);
        this.inventory.setItem(18 + this.column, null);
        this.inventory.setItem(this.column, this.upButton);
        this.inventory.setItem(18 + this.column, this.downButton);
        if (this.value != 0) {
            ItemMeta newItemMeta = this.indicator.getItemMeta();
            newItemMeta.setDisplayName(this.name + " : " + this.value);
            this.indicator.setItemMeta(newItemMeta);
            this.indicator.setAmount(this.value);
            this.inventory.setItem(9 + this.column, this.indicator);
        }
    }

    public boolean react(ItemStack item) {
        if (this.upButton.equals((Object)item)) {
            this.addOne();
            return true;
        }
        if (this.indicator.equals((Object)item)) {
            return true;
        }
        if (this.downButton.equals((Object)item)) {
            this.removeOne();
            return true;
        }
        return false;
    }

    private void addOne() {
        ++this.value;
        if (this.value > 9) {
            this.value = 0;
        }
        this.redrawInventory();
    }

    private void removeOne() {
        --this.value;
        if (this.value < 0) {
            this.value = 9;
        }
        this.redrawInventory();
    }

    public int getCurrentValue() {
        return this.value;
    }

    public void setCurrentValue(int newValue) {
        this.value = newValue;
        this.redrawInventory();
    }
}

