/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.inventorymenu;

import de.tobiyas.util.RaC.inventorymenu.ItemGeneratorInterface;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.material.Wool;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class BasicSelectionInterface
extends ItemGeneratorInterface
implements Listener {
    protected static final List<BasicSelectionInterface> openInterfaces = new LinkedList<BasicSelectionInterface>();
    protected boolean isOpeningNewInv = false;
    protected final JavaPlugin plugin;
    protected final ItemStack BACK_OBJECT;
    protected final ItemStack ACCEPT_OBJECT;
    protected BasicSelectionInterface parent;
    protected final Player player;
    protected final Inventory selectionInventory;
    protected final Inventory controlInventory;
    protected boolean alsoUseLeftClick = false;

    public BasicSelectionInterface(Player player, BasicSelectionInterface parent, String controlInventoryName, String selectionInventoryName, JavaPlugin plugin) {
        this.player = player;
        this.parent = parent;
        this.plugin = plugin;
        if (selectionInventoryName.length() > 32) {
            selectionInventoryName = selectionInventoryName.substring(0, 32);
        }
        if (controlInventoryName.length() > 32) {
            controlInventoryName = controlInventoryName.substring(0, 32);
        }
        this.selectionInventory = Bukkit.createInventory((InventoryHolder)player, (int)27, (String)selectionInventoryName);
        this.controlInventory = Bukkit.createInventory((InventoryHolder)player, (int)36, (String)controlInventoryName);
        this.BACK_OBJECT = this.generateBackItem();
        this.ACCEPT_OBJECT = this.generateAcceptItem();
        this.controlInventory.setItem(0, this.ACCEPT_OBJECT);
        this.controlInventory.setItem(8, this.BACK_OBJECT);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        openInterfaces.add(this);
    }

    public BasicSelectionInterface(Player player, BasicSelectionInterface parent, Inventory topInv, Inventory bottomInv, JavaPlugin plugin) {
        this.player = player;
        this.parent = parent;
        this.plugin = plugin;
        this.selectionInventory = topInv == null ? Bukkit.createInventory((InventoryHolder)player, (int)27) : topInv;
        this.controlInventory = bottomInv == null ? Bukkit.createInventory((InventoryHolder)player, (int)36) : bottomInv;
        this.BACK_OBJECT = this.generateBackItem();
        this.ACCEPT_OBJECT = this.generateAcceptItem();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        openInterfaces.add(this);
    }

    public BasicSelectionInterface(Player player, BasicSelectionInterface parent, JavaPlugin plugin) {
        this(player, parent, "Control", "Data", plugin);
    }

    public Inventory getTopInventory() {
        return this.selectionInventory;
    }

    public Inventory getBottomInventory() {
        return this.controlInventory;
    }

    public HumanEntity getPlayer() {
        return this.player;
    }

    public InventoryType getType() {
        return InventoryType.CHEST;
    }

    @EventHandler
    public void onInterfaceInteract(InventoryClickEvent event) {
        boolean usedTopInv;
        if (event.getView() != this) {
            return;
        }
        ItemStack itemClicked = event.getCurrentItem();
        if (itemClicked == null || itemClicked.getType() == Material.AIR) {
            return;
        }
        event.setCancelled(true);
        if (event.getClick() != ClickType.RIGHT && event.getClick() != ClickType.LEFT) {
            return;
        }
        if (this.ACCEPT_OBJECT.equals((Object)itemClicked)) {
            this.onAcceptPressed();
            return;
        }
        if (this.BACK_OBJECT.equals((Object)itemClicked)) {
            if (this.onBackPressed()) {
                this.scheduleCloseOfInventory();
            }
            return;
        }
        int rawSlot = event.getRawSlot();
        int slotNumber = event.getSlot();
        boolean bl = usedTopInv = rawSlot < this.getTopInventory().getSize();
        if (usedTopInv) {
            this.onSelectionItemPressed(slotNumber, itemClicked);
        } else {
            this.onControlItemPressed(slotNumber, itemClicked);
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (event.getView() != this) {
            return;
        }
        openInterfaces.remove((Object)this);
        if (this.isOpeningNewInv) {
            this.isOpeningNewInv = false;
            return;
        }
        this.openParent();
        HandlerList.unregisterAll((Listener)this);
    }

    protected abstract boolean onBackPressed();

    protected abstract void onAcceptPressed();

    protected void onSelectionItemPressed(ItemStack item) {
    }

    protected void onSelectionItemPressed(int slot, ItemStack item) {
        this.onSelectionItemPressed(item);
    }

    protected void onControlItemPressed(ItemStack item) {
    }

    protected void onControlItemPressed(int slot, ItemStack item) {
        this.onControlItemPressed(item);
    }

    protected void scheduleCloseOfInventory() {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                BasicSelectionInterface.this.player.closeInventory();
            }
        }, 2L);
    }

    protected void scheduleOpeningOfParent() {
        if (this.parent == null) {
            this.resyncInv(this.player);
            return;
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                if (BasicSelectionInterface.this.parent != null) {
                    BasicSelectionInterface.this.player.openInventory((InventoryView)BasicSelectionInterface.this.parent);
                    openInterfaces.add(BasicSelectionInterface.this);
                    BasicSelectionInterface.this.parent.notifyReopened();
                }
            }
        }, 2L);
    }

    protected void notifyReopened() {
    }

    private void openParent() {
        this.scheduleOpeningOfParent();
    }

    protected void closeAndReturnToParent() {
        this.scheduleCloseOfInventory();
    }

    protected void openNewView(final BasicSelectionInterface newView) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                BasicSelectionInterface.this.isOpeningNewInv = true;
                BasicSelectionInterface.this.player.openInventory((InventoryView)newView);
            }
        }, 1L);
    }

    private ItemStack generateBackItem() {
        ItemStack item = new Wool(DyeColor.RED).toItemStack();
        ItemMeta meta = item.getItemMeta();
        if (this.parent == null) {
            meta.setDisplayName(ChatColor.RED + "Exit");
        } else {
            meta.setDisplayName(ChatColor.RED + "ABORT");
        }
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack generateAcceptItem() {
        ItemStack item = new Wool(DyeColor.GREEN).toItemStack();
        ItemMeta meta = item.getItemMeta();
        if (this.parent == null) {
            meta.setDisplayName(ChatColor.RED + "Save");
        } else {
            meta.setDisplayName(ChatColor.GREEN + "Accept");
        }
        item.setItemMeta(meta);
        return item;
    }

    private void resyncInv(final Player player) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                player.updateInventory();
            }
        }, 1L);
    }

    public static void closeAllInvs() {
        if (openInterfaces.isEmpty()) {
            return;
        }
        for (BasicSelectionInterface gui : new HashSet<BasicSelectionInterface>(openInterfaces)) {
            Player player = (Player)gui.getPlayer();
            if (player == null || !player.isOnline()) continue;
            player.closeInventory();
            player.updateInventory();
        }
    }
}

