/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.formating;

import de.tobiyas.util.RaC.math.Math2;
import java.util.Collection;
import java.util.Iterator;
import org.bukkit.ChatColor;

public class StringFormatUtils {
    public static String firstCapitalRestLow(String value) {
        return value.substring(0, 1).toUpperCase() + value.substring(1).toLowerCase();
    }

    public static int parseInt(String val, int defaultValue) {
        try {
            return Integer.parseInt(val);
        }
        catch (Throwable exp) {
            return defaultValue;
        }
    }

    public static double parseDouble(String val, double defaultValue) {
        try {
            return Double.parseDouble(val);
        }
        catch (Throwable exp) {
            return defaultValue;
        }
    }

    public static String formatToPercent(double percent, int barLength, char charToUse, ChatColor fullColor, ChatColor emptyColor) {
        if (percent <= 0.0) {
            percent = 0.0;
        }
        double presentBarLength = percent * (double)barLength;
        presentBarLength = Math2.clamp(0.0, presentBarLength, (double)barLength);
        String barLeft = fullColor + "";
        int i = 0;
        while ((double)i < presentBarLength) {
            barLeft = barLeft + charToUse;
            --barLength;
            ++i;
        }
        String barRest = emptyColor + "";
        while (barLength > 0) {
            barRest = barRest + charToUse;
            --barLength;
        }
        barRest = percent >= 1.0 ? barRest + fullColor.toString() + charToUse : barRest + emptyColor.toString() + charToUse;
        String chatString = barLeft + barRest;
        return chatString;
    }

    public static boolean equalsAny(String main, String ... part) {
        for (String par : part) {
            if (!par.equalsIgnoreCase(main)) continue;
            return true;
        }
        return false;
    }

    public static String join(String delimiter, Object ... data) {
        String result = "";
        for (int i = 0; i < data.length; ++i) {
            if (i != 0) {
                result = result + delimiter;
            }
            result = result + data[i];
        }
        return result;
    }

    public static String join(String delimiter, Collection<?> data) {
        String result = "";
        Iterator<?> it = data.iterator();
        while (it.hasNext()) {
            if (!result.isEmpty()) {
                result = result + delimiter;
            }
            result = result + it.next();
        }
        return result;
    }
}

