/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.formating;

import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.EntityType;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.util.Vector;

public class ParseUtils {
    public static int parseInt(String value, int defaultValue) {
        try {
            return Integer.parseInt(value);
        }
        catch (Throwable exp) {
            return defaultValue;
        }
    }

    public static int parseInt(Object value, int defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value.toString());
        }
        catch (Throwable exp) {
            return defaultValue;
        }
    }

    public static int parseInt(String[] args, int index, int defaultValue) {
        try {
            return Integer.parseInt(args[index]);
        }
        catch (Throwable exp) {
            return defaultValue;
        }
    }

    public static short parseShort(String value, short defaultValue) {
        try {
            return Short.parseShort(value);
        }
        catch (Throwable exp) {
            return defaultValue;
        }
    }

    public static short parseShort(String[] args, int index, short defaultValue) {
        try {
            return Short.parseShort(args[index]);
        }
        catch (Throwable exp) {
            return defaultValue;
        }
    }

    public static double parseDouble(String value, double defaultValue) {
        try {
            return Double.parseDouble(value);
        }
        catch (Throwable exp) {
            return defaultValue;
        }
    }

    public static double parseDouble(Object value, double defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(value.toString());
        }
        catch (Throwable exp) {
            return defaultValue;
        }
    }

    public static double parseDouble(String[] args, int index, double defaultValue) {
        try {
            return Double.parseDouble(args[index]);
        }
        catch (Throwable exp) {
            return defaultValue;
        }
    }

    public static boolean parseBoolean(String value, boolean defaultValue) {
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("yes")) {
            return true;
        }
        if (value.equalsIgnoreCase("ja")) {
            return true;
        }
        if (value.equalsIgnoreCase("on")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        if (value.equalsIgnoreCase("no")) {
            return false;
        }
        if (value.equalsIgnoreCase("nein")) {
            return false;
        }
        if (value.equalsIgnoreCase("off")) {
            return false;
        }
        return defaultValue;
    }

    public static boolean parseBoolean(Object value, boolean defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return ParseUtils.parseBoolean(value.toString(), defaultValue);
    }

    public static boolean parseBoolean(String[] args, int index, boolean defaultValue) {
        return ParseUtils.parseBoolean(args[index], defaultValue);
    }

    public static float parseFloat(String value, float defaultValue) {
        try {
            return Float.parseFloat(value);
        }
        catch (Throwable exp) {
            return defaultValue;
        }
    }

    public static float parseFloat(String[] args, int index, float defaultValue) {
        try {
            return Float.parseFloat(args[index]);
        }
        catch (Throwable exp) {
            return defaultValue;
        }
    }

    public static String parseString(Object value, String defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return value.toString();
    }

    public static String parseString(String[] values, int index, String defaultValue) {
        try {
            return values[index];
        }
        catch (Throwable exp) {
            return defaultValue;
        }
    }

    public static long parseLong(String value, long defaultValue) {
        try {
            return Long.parseLong(value);
        }
        catch (Throwable exp) {
            return defaultValue;
        }
    }

    public static long parseLong(Object value, long defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value.toString());
        }
        catch (Throwable exp) {
            return defaultValue;
        }
    }

    public static long parseLong(String[] args, int index, long defaultValue) {
        try {
            return Long.parseLong(args[index]);
        }
        catch (Throwable exp) {
            return defaultValue;
        }
    }

    public static EntityDamageEvent.DamageCause parseDamageCause(String value, EntityDamageEvent.DamageCause defaultValue) {
        try {
            return EntityDamageEvent.DamageCause.valueOf((String)value.toUpperCase());
        }
        catch (Throwable exp) {
            return defaultValue;
        }
    }

    public static EntityDamageEvent.DamageCause parseDamageCause(Object value, EntityDamageEvent.DamageCause defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        try {
            return EntityDamageEvent.DamageCause.valueOf((String)value.toString().toUpperCase());
        }
        catch (Throwable exp) {
            return defaultValue;
        }
    }

    public static EntityDamageEvent.DamageCause parseDamageCause(String[] args, int index, EntityDamageEvent.DamageCause defaultValue) {
        try {
            return EntityDamageEvent.DamageCause.valueOf((String)args[index].toUpperCase());
        }
        catch (Throwable exp) {
            return defaultValue;
        }
    }

    public static EntityType parseEntityType(String value, EntityType defaultValue) {
        try {
            return EntityType.valueOf((String)value.toUpperCase());
        }
        catch (Throwable exp) {
            return defaultValue;
        }
    }

    public static EntityType parseEntityType(Object value, EntityType defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        try {
            return EntityType.valueOf((String)value.toString().toUpperCase());
        }
        catch (Throwable exp) {
            return defaultValue;
        }
    }

    public static EntityType parseEntityType(String[] args, int index, EntityType defaultValue) {
        try {
            return EntityType.valueOf((String)args[index].toUpperCase());
        }
        catch (Throwable exp) {
            return defaultValue;
        }
    }

    public static Material parseMaterial(String value, Material defaultValue) {
        try {
            return Material.matchMaterial((String)value);
        }
        catch (Throwable exp) {
            return defaultValue;
        }
    }

    public static Material parseMaterial(Object value, Material defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        try {
            return Material.matchMaterial((String)value.toString());
        }
        catch (Throwable exp) {
            return defaultValue;
        }
    }

    public static Material parseMaterial(String[] args, int index, Material defaultValue) {
        try {
            return Material.matchMaterial((String)args[index]);
        }
        catch (Throwable exp) {
            return defaultValue;
        }
    }

    public static Location parseLocation(String value, Location defaultValue) {
        try {
            String[] parts = value.split(Pattern.quote(";"));
            if (parts.length != 4 && (parts = value.split(Pattern.quote("#"))).length != 4) {
                return defaultValue;
            }
            World world = Bukkit.getWorld((String)parts[0]);
            double x = Double.parseDouble(parts[1]);
            double y = Double.parseDouble(parts[2]);
            double z = Double.parseDouble(parts[3]);
            if (world == null) {
                return defaultValue;
            }
            return new Location(world, x, y, z);
        }
        catch (Throwable exp) {
            return defaultValue;
        }
    }

    public static Location parseLocationObj(Object value, Location defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        try {
            if (value instanceof Location) {
                return (Location)value;
            }
            return ParseUtils.parseLocation(value.toString(), defaultValue);
        }
        catch (Throwable exp) {
            return defaultValue;
        }
    }

    public static Location parseLocation(String[] args, int index, Location defaultValue) {
        try {
            return ParseUtils.parseLocation(args[index], defaultValue);
        }
        catch (Throwable exp) {
            return defaultValue;
        }
    }

    public static Vector parseVector(String value, Vector defaultValue) {
        try {
            String[] parts = value.split(Pattern.quote(";"));
            if (parts.length != 3 && (parts = value.split(Pattern.quote("#"))).length != 3) {
                return defaultValue;
            }
            double x = Double.parseDouble(parts[0]);
            double y = Double.parseDouble(parts[1]);
            double z = Double.parseDouble(parts[2]);
            return new Vector(x, y, z);
        }
        catch (Throwable exp) {
            return defaultValue;
        }
    }

    public static Vector parseLocation(Object value, Vector defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        try {
            if (value instanceof Vector) {
                return (Vector)value;
            }
            return ParseUtils.parseVector(value.toString(), defaultValue);
        }
        catch (Throwable exp) {
            return defaultValue;
        }
    }

    public static Vector parseVector(String[] args, int index, Vector defaultValue) {
        try {
            return ParseUtils.parseVector(args[index], defaultValue);
        }
        catch (Throwable exp) {
            return defaultValue;
        }
    }
}

