/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.formating;

import de.tobiyas.util.RaC.chat.components.TellRawChatMessage;
import de.tobiyas.util.RaC.math.Math2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class CommandFormatUtils {
    public static <T> List<T> getElements(List<T> data, int page, int pageSize) {
        int maxPage = (int)Math.ceil((double)data.size() / (double)pageSize);
        page = Math2.clamp(1, page, maxPage);
        int maxIndex = data.size();
        int start = (page - 1) * pageSize;
        int end = Math.min(page * pageSize - 1, maxIndex);
        return data.subList(start, end);
    }

    public static class PagePackage<T> {
        private final List<T> sorted;
        private final int pageSize;
        private final int lastPage;

        public PagePackage(Collection<T> collection, Comparator<T> sorter, int pageSize) {
            this.sorted = new ArrayList<T>(collection);
            Collections.sort(this.sorted, sorter);
            this.pageSize = pageSize;
            double size = this.sorted.size();
            double pSize = pageSize;
            this.lastPage = (int)Math.ceil(size / pSize);
        }

        public List<T> getPage(int page) {
            page = Math2.clamp(1, page, this.lastPage);
            int maxIndex = this.sorted.size();
            int start = (page - 1) * this.pageSize;
            int end = Math.min(page * this.pageSize, maxIndex);
            return this.sorted.subList(start, end);
        }

        public int getLastPage() {
            return this.lastPage;
        }

        public int getPageSize() {
            return this.pageSize;
        }

        public TellRawChatMessage generateBottomLine(int page, String command) {
            TellRawChatMessage message = new TellRawChatMessage().addSimpleText("        ");
            message = page > 1 ? message.addSimpleCommand("<<", "Page " + (page - 1), String.format(command, page - 1)) : message.addSimpleText("    ");
            message = message.addSimpleText(" | ");
            if (page < this.getLastPage()) {
                message = message.addSimpleCommand(">>", "Page " + (page + 1), String.format(command, page + 1));
            }
            return message;
        }
    }
}

