/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.file;

import java.io.File;
import java.io.FileFilter;
import java.util.HashSet;
import java.util.Set;

public class FileUtils {
    public static Set<File> getAllFiles(File base, FileFilter filter) {
        HashSet<File> files = new HashSet<File>();
        if (base.isFile()) {
            if (filter == null || filter.accept(base)) {
                files.add(base);
            }
            return files;
        }
        for (File file : base.listFiles()) {
            files.addAll(FileUtils.getAllFiles(file, filter));
        }
        return files;
    }

    public static Set<File> getAllFiles(File base) {
        return FileUtils.getAllFiles(base, null);
    }

    public static void deleteFileRecursivly(File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files != null && files.length > 0) {
                for (File f : files) {
                    FileUtils.deleteFileRecursivly(f);
                }
            }
            file.delete();
            return;
        }
        if (file.isFile()) {
            try {
                file.delete();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return;
        }
    }
}

