/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.evaluations.parts.leafs;

import de.tobiyas.util.RaC.evaluations.parts.Calculation;
import java.text.DecimalFormat;
import java.util.Map;
import java.util.regex.Pattern;

public class Variable
implements Calculation {
    private static final DecimalFormat format = new DecimalFormat("0.0");
    private final String variable;
    private final double defaultValue;

    public Variable(String variable) {
        String var = variable.replace("%", "").replace("{", "").replace("}", "").toLowerCase();
        double def = 0.0;
        if (var.contains("=")) {
            String[] parts = var.split(Pattern.quote("="));
            var = parts[0];
            try {
                def = Double.parseDouble(parts[1]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.variable = var;
        this.defaultValue = def;
    }

    @Override
    public double calculate(Map<String, Double> variables) {
        return variables.containsKey(this.variable) ? variables.get(this.variable) : this.defaultValue;
    }

    @Override
    public String toString() {
        String defaultAdd = this.defaultValue == 0.0 ? "" : "=" + format.format(this.defaultValue);
        return "%" + this.variable.toUpperCase() + defaultAdd + "%";
    }
}

