/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.evaluations;

import de.tobiyas.util.RaC.evaluations.parts.Calculation;
import de.tobiyas.util.RaC.evaluations.parts.Operator;
import de.tobiyas.util.RaC.evaluations.parts.SinglePartOperator;
import de.tobiyas.util.RaC.evaluations.parts.leafs.Number;
import de.tobiyas.util.RaC.evaluations.parts.leafs.Variable;
import de.tobiyas.util.RaC.evaluations.parts.operators.multi.Add;
import de.tobiyas.util.RaC.evaluations.parts.operators.multi.Divide;
import de.tobiyas.util.RaC.evaluations.parts.operators.multi.Multiply;
import de.tobiyas.util.RaC.evaluations.parts.operators.multi.Subtract;
import de.tobiyas.util.RaC.evaluations.parts.operators.single.Square;
import de.tobiyas.util.RaC.evaluations.parts.operators.single.SquareRoot;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class EvalEvaluator {
    private static final Collection<Character> operators = Arrays.asList(Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('*'), Character.valueOf('/'));
    private static final Collection<Character> bracket = Arrays.asList(Character.valueOf('('), Character.valueOf(')'));
    private static final Collection<String> singleOps = Arrays.asList("SQRT");

    private static List<String> splitStuff(String toSplit) {
        toSplit = toSplit.replace(" ", "");
        ArrayList<String> splittet = new ArrayList<String>();
        if (toSplit.isEmpty()) {
            return splittet;
        }
        int index = 0;
        String currentData = "";
        boolean isCurrentlyVariable = false;
        while (index < toSplit.length()) {
            char currentChar = toSplit.charAt(index);
            ++index;
            if ((currentChar == '%' || currentChar == '}') && isCurrentlyVariable) {
                currentData = currentData + currentChar;
                splittet.add(currentData);
                currentData = "";
                isCurrentlyVariable = false;
                continue;
            }
            if (!(currentChar != '%' && currentChar != '{' || isCurrentlyVariable)) {
                currentData = currentData + currentChar;
                isCurrentlyVariable = true;
                continue;
            }
            if (operators.contains(Character.valueOf(currentChar))) {
                if (!currentData.isEmpty()) {
                    splittet.add(currentData);
                }
                currentData = "";
                splittet.add(String.valueOf(currentChar));
                continue;
            }
            if (bracket.contains(Character.valueOf(currentChar))) {
                if (!currentData.isEmpty()) {
                    splittet.add(currentData);
                }
                currentData = "";
                splittet.add(String.valueOf(currentChar));
                continue;
            }
            if (singleOps.contains(currentData.toUpperCase())) {
                splittet.add(currentData.toUpperCase());
                currentData = "";
            }
            currentData = currentData + currentChar;
        }
        return splittet;
    }

    public static List<String> getWrongElements(String calcString) {
        return EvalEvaluator.getWrongElements(EvalEvaluator.splitStuff(calcString));
    }

    private static List<String> getWrongElements(List<String> toCheck) {
        LinkedList<String> wrongElements = new LinkedList<String>();
        for (String key : toCheck) {
            char singleChar;
            if (key.length() == 1 && (bracket.contains(Character.valueOf(singleChar = key.charAt(0))) || operators.contains(Character.valueOf(singleChar))) || key.length() > 2 && key.startsWith("%") && key.endsWith("%") || key.length() > 2 && key.startsWith("{") && key.endsWith("}")) continue;
            try {
                Double.parseDouble(key);
            }
            catch (Throwable throwable) {
                if (singleOps.contains(key)) continue;
                wrongElements.add(key);
            }
        }
        String last = "";
        for (int i = toCheck.size() - 1; i >= 0 && (last = toCheck.get(i)).equals(")"); --i) {
        }
        if (singleOps.contains(last) || operators.contains(Character.valueOf(last.charAt(0)))) {
            wrongElements.add(last + " (operator at the end)");
        }
        return wrongElements;
    }

    private static boolean hasCorrectBracketSynthax(List<String> toCheck) {
        int currentOpenBraket = 0;
        int braketOpen = 0;
        int braketClose = 0;
        for (String key : toCheck) {
            boolean isOpen = key.equals("(");
            boolean isClose = key.equals(")");
            if (isOpen) {
                ++braketOpen;
                ++currentOpenBraket;
            }
            if (!isClose) continue;
            ++braketClose;
            if (--currentOpenBraket >= 0) continue;
            return false;
        }
        return currentOpenBraket == 0 && braketOpen == braketClose;
    }

    public static Calculation parse(String toParse) throws IllegalArgumentException {
        toParse = "(" + toParse + ")";
        List<String> parsed = EvalEvaluator.splitStuff(toParse);
        return EvalEvaluator.parse(parsed);
    }

    private static Calculation parse(List<String> toParse) throws IllegalArgumentException {
        if (toParse == null || toParse.isEmpty()) {
            throw new IllegalArgumentException("Calculation is empty!");
        }
        if (!EvalEvaluator.hasCorrectBracketSynthax(toParse)) {
            throw new IllegalArgumentException("Brakets are not correct!");
        }
        List<String> wrongElements = EvalEvaluator.getWrongElements(toParse);
        if (!wrongElements.isEmpty()) {
            throw new IllegalArgumentException("Some elements are not correct or can not be identified: " + StringUtils.join(wrongElements, (String)" "));
        }
        List<Object> calculations = new ArrayList<Object>(toParse);
        EvalEvaluator.replaceLeafes(calculations);
        EvalEvaluator.replaceOperators(calculations);
        calculations = EvalEvaluator.parseBrackets(calculations.iterator());
        return EvalEvaluator.simplifyList(calculations);
    }

    private static void replaceLeafes(List<Object> calculations) {
        for (int i = 0; i < calculations.size(); ++i) {
            Object toCheck = calculations.get(i);
            if (toCheck instanceof Calculation) continue;
            String toConvert = toCheck.toString();
            try {
                double number = Double.parseDouble(toConvert);
                calculations.set(i, new Number(number));
                continue;
            }
            catch (Throwable throwable) {
                if (toConvert.length() > 2 && toConvert.startsWith("%") && toConvert.endsWith("%")) {
                    calculations.set(i, new Variable(toConvert));
                    continue;
                }
                if (toConvert.length() <= 2 || !toConvert.startsWith("{") || !toConvert.endsWith("}")) continue;
                calculations.set(i, new Variable(toConvert));
            }
        }
    }

    private static void replaceOperators(List<Object> calculations) {
        for (int i = 0; i < calculations.size(); ++i) {
            Object toCheck = calculations.get(i);
            if (toCheck instanceof Calculation) continue;
            String toParse = toCheck.toString();
            if (toParse.equals("+")) {
                calculations.set(i, new Add());
            }
            if (toParse.equals("-")) {
                calculations.set(i, new Subtract());
            }
            if (toParse.equals("*")) {
                calculations.set(i, new Multiply());
            }
            if (toParse.equals("/")) {
                calculations.set(i, new Divide());
            }
            if (toParse.equals("SQRT")) {
                calculations.set(i, new SquareRoot());
            }
            if (!toParse.equals("SQR")) continue;
            calculations.set(i, new Square());
        }
    }

    private static List<Object> parseBrackets(Iterator<Object> it) {
        LinkedList<Object> result = new LinkedList<Object>();
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj instanceof Calculation) {
                result.add(obj);
                continue;
            }
            String toCheck = (String)obj;
            if (toCheck.equals("(")) {
                List<Object> inside = EvalEvaluator.parseBrackets(it);
                result.add(inside);
                continue;
            }
            if (!toCheck.equals(")")) continue;
            return result;
        }
        return result;
    }

    private static Calculation simplifyList(List<Object> list) {
        Calculation left;
        Calculation operator;
        Calculation right;
        Calculation current;
        LinkedList<Calculation> calcs = new LinkedList<Calculation>();
        for (Object obj : list) {
            if (obj instanceof List) {
                calcs.add(EvalEvaluator.simplifyList((List)obj));
                continue;
            }
            if (obj instanceof Calculation) {
                calcs.add((Calculation)obj);
                continue;
            }
            throw new RuntimeException("Was not a list or Calculation!");
        }
        boolean gotOne = true;
        block1: while (gotOne) {
            gotOne = false;
            for (int i = calcs.size() - 2; i >= 0; --i) {
                current = (Calculation)calcs.get(i);
                right = (Calculation)calcs.get(i + 1);
                if (!(current instanceof SinglePartOperator) || (operator = (SinglePartOperator)current).getPart() != null) continue;
                operator.setPart(right);
                calcs.remove(i + 1);
                gotOne = true;
                continue block1;
            }
        }
        gotOne = true;
        block3: while (gotOne) {
            gotOne = false;
            for (int i = calcs.size() - 2; i >= 0; --i) {
                current = (Calculation)calcs.get(i);
                right = (Calculation)calcs.get(i + 1);
                if (!(current instanceof Multiply) && !(current instanceof Divide) || (operator = (Operator)current).getPart2() != null) continue;
                operator.setPart2(right);
                calcs.remove(i + 1);
                gotOne = true;
                continue block3;
            }
        }
        gotOne = true;
        block5: while (gotOne) {
            gotOne = false;
            for (int i = 1; i < calcs.size(); ++i) {
                current = (Calculation)calcs.get(i);
                left = (Calculation)calcs.get(i - 1);
                if (!(current instanceof Multiply) && !(current instanceof Divide) || (operator = (Operator)current).getPart1() != null) continue;
                operator.setPart1(left);
                calcs.remove(i - 1);
                gotOne = true;
                continue block5;
            }
        }
        gotOne = true;
        block7: while (gotOne) {
            gotOne = false;
            for (int i = calcs.size() - 2; i >= 0; --i) {
                current = (Calculation)calcs.get(i);
                right = (Calculation)calcs.get(i + 1);
                if (!(current instanceof Add) && !(current instanceof Subtract) || (operator = (Operator)current).getPart2() != null) continue;
                operator.setPart2(right);
                calcs.remove(i + 1);
                gotOne = true;
                continue block7;
            }
        }
        gotOne = true;
        block9: while (gotOne) {
            gotOne = false;
            for (int i = 1; i < calcs.size(); ++i) {
                current = (Calculation)calcs.get(i);
                left = (Calculation)calcs.get(i - 1);
                if (!(current instanceof Add) && !(current instanceof Subtract) || (operator = (Operator)current).getPart1() != null) continue;
                operator.setPart1(left);
                calcs.remove(i - 1);
                gotOne = true;
                continue block9;
            }
        }
        return (Calculation)calcs.get(0);
    }
}

