/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.entitysearch;

import de.tobiyas.util.RaC.math.Bresenham;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.BlockIterator;

public class SearchEntity {
    public static <T extends LivingEntity> T inLineOfSight(int maxDistance, LivingEntity toSearchFrom) {
        List nearEntities = toSearchFrom.getNearbyEntities((double)(maxDistance * 2), (double)(maxDistance * 2), (double)(maxDistance * 2));
        Iterator entityIt = nearEntities.iterator();
        while (entityIt.hasNext()) {
            Entity entityToCheck = (Entity)entityIt.next();
            boolean remove = false;
            if (!(entityToCheck instanceof LivingEntity)) {
                remove = true;
            }
            try {
                LivingEntity livingEntity = (LivingEntity)entityToCheck;
            }
            catch (ClassCastException exp) {
                remove = true;
            }
            if (!remove) continue;
            entityIt.remove();
        }
        BlockIterator blockIt = new BlockIterator(toSearchFrom, maxDistance);
        while (blockIt.hasNext()) {
            Block block = (Block)blockIt.next();
            for (Entity entity : nearEntities) {
                double distanceEye;
                double distance = block.getLocation().distanceSquared(entity.getLocation());
                if (distance < 2.0) {
                    return (T)((LivingEntity)entity);
                }
                if (!(entity instanceof LivingEntity) || !((distanceEye = block.getLocation().distanceSquared(((LivingEntity)entity).getEyeLocation())) < 2.0)) continue;
                return (T)((LivingEntity)entity);
            }
        }
        return null;
    }

    public static Entity getEntityInLineOfSight(int maxDistance, LivingEntity toSearchFrom) {
        if (toSearchFrom == null) {
            return null;
        }
        List nearEntities = toSearchFrom.getNearbyEntities((double)(maxDistance * 2), (double)(maxDistance * 2), (double)(maxDistance * 2));
        BlockIterator blockIt = null;
        try {
            blockIt = new BlockIterator(toSearchFrom, maxDistance);
        }
        catch (IllegalStateException exp) {
            return null;
        }
        while (blockIt.hasNext()) {
            Block block = (Block)blockIt.next();
            if (block.getType().isOccluding()) {
                return null;
            }
            for (Entity entity : nearEntities) {
                double distanceEye;
                double distance = block.getLocation().distanceSquared(entity.getLocation());
                if (distance < 1.0) {
                    return entity;
                }
                distance = block.getLocation().distanceSquared(entity.getLocation().clone().add(0.0, 1.0, 0.0));
                if (distance < 1.0) {
                    return entity;
                }
                distance = block.getLocation().distanceSquared(entity.getLocation().clone().add(0.0, 2.0, 0.0));
                if (distance < 1.0) {
                    return entity;
                }
                if (!(entity instanceof LivingEntity) || !((distanceEye = block.getLocation().distanceSquared(((LivingEntity)entity).getEyeLocation())) < 1.0)) continue;
                return entity;
            }
        }
        return null;
    }

    public static Entity getEntityInLineOfSight(int maxDistance, LivingEntity toSearchFrom, Set<EntityType> toSkip) {
        List nearEntities = toSearchFrom.getNearbyEntities((double)(maxDistance * 2), (double)(maxDistance * 2), (double)(maxDistance * 2));
        BlockIterator blockIt = null;
        try {
            blockIt = new BlockIterator(toSearchFrom, maxDistance);
        }
        catch (IllegalStateException exp) {
            return null;
        }
        while (blockIt.hasNext()) {
            Block block = (Block)blockIt.next();
            if (block.getType().isOccluding()) {
                return null;
            }
            for (Entity entity : nearEntities) {
                double distanceEye;
                if (toSkip.contains(entity.getType())) continue;
                double distance = block.getLocation().distanceSquared(entity.getLocation());
                if (distance < 1.0) {
                    return entity;
                }
                distance = block.getLocation().distanceSquared(entity.getLocation().clone().add(0.0, 1.0, 0.0));
                if (distance < 1.0) {
                    return entity;
                }
                distance = block.getLocation().distanceSquared(entity.getLocation().clone().add(0.0, 2.0, 0.0));
                if (distance < 1.0) {
                    return entity;
                }
                if (!(entity instanceof LivingEntity) || !((distanceEye = block.getLocation().distanceSquared(((LivingEntity)entity).getEyeLocation())) < 1.0)) continue;
                return entity;
            }
        }
        return null;
    }

    public static LivingEntity inLineOfSight(int maxDistance, LivingEntity toSearchFrom, EntityType toSearch) {
        List nearEntities = toSearchFrom.getNearbyEntities((double)(maxDistance * 2), (double)(maxDistance * 2), (double)(maxDistance * 2));
        Iterator entityIt = nearEntities.iterator();
        while (entityIt.hasNext()) {
            Entity entityToCheck = (Entity)entityIt.next();
            boolean remove = false;
            if (!(entityToCheck instanceof LivingEntity)) {
                remove = true;
            }
            if (entityToCheck.getType() != toSearch) {
                remove = true;
            }
            if (!remove) continue;
            entityIt.remove();
        }
        BlockIterator blockIt = new BlockIterator(toSearchFrom, maxDistance);
        while (blockIt.hasNext()) {
            Block block = (Block)blockIt.next();
            for (Entity entity : nearEntities) {
                double distance = block.getLocation().distanceSquared(entity.getLocation());
                if (distance < 2.0) {
                    return (LivingEntity)entity;
                }
                double distanceEye = block.getLocation().distanceSquared(((LivingEntity)entity).getEyeLocation());
                if (!(distanceEye < 2.0)) continue;
                return (LivingEntity)entity;
            }
        }
        return null;
    }

    public static Set<LivingEntity> allInLineOfSight(int maxDistance, LivingEntity toSearchFrom) {
        List nearEntities = toSearchFrom.getNearbyEntities((double)(maxDistance * 2), (double)(maxDistance * 2), (double)(maxDistance * 2));
        Iterator entityIt = nearEntities.iterator();
        while (entityIt.hasNext()) {
            Entity entityToCheck = (Entity)entityIt.next();
            if (entityToCheck instanceof LivingEntity) continue;
            entityIt.remove();
        }
        HashSet<LivingEntity> targets = new HashSet<LivingEntity>();
        BlockIterator blockIt = new BlockIterator(toSearchFrom, maxDistance);
        int i = 0;
        while (blockIt.hasNext()) {
            Block block = (Block)blockIt.next();
            for (Entity entity : nearEntities) {
                double distanceEye;
                double distance = block.getLocation().distanceSquared(entity.getLocation());
                if (distance <= 2.0) {
                    targets.add((LivingEntity)entity);
                    continue;
                }
                if (!(entity instanceof LivingEntity) || !((distanceEye = block.getLocation().distanceSquared(((LivingEntity)entity).getEyeLocation())) <= 2.0)) continue;
                targets.add((LivingEntity)entity);
            }
            if (++i < maxDistance) continue;
            break;
        }
        return targets;
    }

    public static List<Entity> inCircleAround(Entity around, double range) {
        List entities = around.getNearbyEntities(range, range, range);
        double rangeSpauare = range * range;
        Location base = around.getLocation();
        Iterator it = entities.iterator();
        while (it.hasNext()) {
            if (!(((Entity)it.next()).getLocation().distanceSquared(base) > rangeSpauare)) continue;
            it.remove();
        }
        return entities;
    }

    public static Collection<Entity> inCircleAround(Location base, double range) {
        Collection entities = base.getWorld().getNearbyEntities(base, range, range, range);
        double rangeSpauare = range * range;
        Iterator it = entities.iterator();
        while (it.hasNext()) {
            if (!(((Entity)it.next()).getLocation().distanceSquared(base) > rangeSpauare)) continue;
            it.remove();
        }
        return entities;
    }

    public static Collection<LivingEntity> inCircleAroundLiving(Location base, double range) {
        Collection entities = base.getWorld().getNearbyEntities(base, range, range, range);
        double rangeSqauare = range * range;
        ArrayList<LivingEntity> result = new ArrayList<LivingEntity>();
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity) || entity.getLocation().distanceSquared(base) > rangeSqauare) continue;
            result.add((LivingEntity)entity);
        }
        return result;
    }

    public static Queue<Location> getAllOnWay(Location loc1, Location loc2) {
        return Bresenham.line3D(loc1, loc2);
    }
}

