/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.economy.plugins;

import de.tobiyas.util.RaC.economy.plugins.AbstractMoneyPlugin;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.RegisteredServiceProvider;

public class VaultMoney
extends AbstractMoneyPlugin {
    private boolean isActive = this.initVault();
    private Economy vaultEconomy;

    @Override
    public double getMoneyOfPlayer(OfflinePlayer player) {
        if (!this.isActive) {
            return 0.0;
        }
        return this.vaultEconomy.getBalance(player);
    }

    @Override
    public boolean addMoney(OfflinePlayer player, double amount) {
        if (!this.isActive) {
            return false;
        }
        if (!this.vaultEconomy.hasAccount(player)) {
            return false;
        }
        this.vaultEconomy.depositPlayer(player, amount);
        return true;
    }

    @Override
    public boolean transferMoney(OfflinePlayer from, OfflinePlayer to, double amount) {
        if (!this.isActive) {
            return false;
        }
        if (!this.vaultEconomy.hasAccount(from)) {
            return false;
        }
        if (!this.vaultEconomy.hasAccount(to)) {
            return false;
        }
        if (!this.vaultEconomy.has(from, amount)) {
            return false;
        }
        this.vaultEconomy.withdrawPlayer(from, amount);
        this.vaultEconomy.depositPlayer(to, amount);
        return true;
    }

    @Override
    public boolean removeMoney(OfflinePlayer player, double amount) {
        if (!this.isActive) {
            return false;
        }
        this.vaultEconomy.withdrawPlayer(player, amount);
        return true;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    private boolean initVault() {
        try {
            RegisteredServiceProvider economyProvider = Bukkit.getServer().getServicesManager().getRegistration(Economy.class);
            if (economyProvider != null) {
                this.vaultEconomy = (Economy)economyProvider.getProvider();
            }
            return this.vaultEconomy != null;
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
    }

    @Override
    public String getName() {
        return "Vault";
    }

    @Override
    public void createBankAccount(String name, OfflinePlayer owner) {
        this.vaultEconomy.createBank(name, owner);
    }

    @Override
    public void removeBankAccount(String name) {
        this.vaultEconomy.deleteBank(name);
    }

    @Override
    public boolean addToBankAccount(String name, double amount) {
        if (!this.isActive) {
            return false;
        }
        this.vaultEconomy.bankDeposit(name, amount);
        return true;
    }

    @Override
    public boolean withdrawFromBankAccount(String name, double amount) {
        if (this.getBankBalance(name) < amount) {
            return false;
        }
        this.vaultEconomy.bankWithdraw(name, amount);
        return true;
    }

    @Override
    public double getBankBalance(String bankName) {
        return this.vaultEconomy.bankBalance((String)bankName).balance;
    }

    @Override
    public boolean hasBankSupport() {
        return this.vaultEconomy.hasBankSupport();
    }
}

