/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.economy.plugins;

import de.tobiyas.curencies.API.CurrencyAPI;
import de.tobiyas.util.RaC.economy.plugins.AbstractMoneyPlugin;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

public class OwnCurrencyPlugin
extends AbstractMoneyPlugin {
    private boolean isPresent() {
        return Bukkit.getPluginManager().isPluginEnabled("Currencies");
    }

    @Override
    public boolean isActive() {
        return this.isPresent();
    }

    @Override
    public double getMoneyOfPlayer(OfflinePlayer player) {
        return CurrencyAPI.getDefaultCurrencyOfPlayer((UUID)player.getUniqueId());
    }

    @Override
    public boolean addMoney(OfflinePlayer player, double amount) {
        CurrencyAPI.addDefaultCurrencyOfPlayer((UUID)player.getUniqueId(), (double)amount);
        return true;
    }

    @Override
    public boolean transferMoney(OfflinePlayer from, OfflinePlayer to, double amount) {
        double money = this.getMoneyOfPlayer(from);
        if (money < amount) {
            return false;
        }
        this.removeMoney(from, amount);
        this.addMoney(to, amount);
        return true;
    }

    @Override
    public boolean removeMoney(OfflinePlayer player, double amount) {
        CurrencyAPI.removeDefaultCurrencyOfPlayer((UUID)player.getUniqueId(), (double)amount);
        return true;
    }

    @Override
    public void removeBankAccount(String name) {
    }

    @Override
    public boolean addToBankAccount(String name, double amount) {
        return false;
    }

    @Override
    public boolean withdrawFromBankAccount(String name, double amount) {
        return false;
    }

    @Override
    public double getBankBalance(String bankName) {
        return 0.0;
    }

    @Override
    public boolean hasBankSupport() {
        return false;
    }

    @Override
    public String getName() {
        return "Currencies";
    }

    @Override
    public void createBankAccount(String name, OfflinePlayer owner) {
    }
}

